PASSWORD.SYS(8)         XROUTER REFERENCE MANUAL            18/10/2023

NAME
        PASSWORD.SYS -- Sysop Password File (Optional).

DESCRIPTION
        This optional file contains the sysop passwords for AX25
        remote access, RLOGIN and FTP.  If the file is not present,
        these forms of access will not be possible.

        These passwords are for SYSOPS only (passwords for users
        are stored in USERPASS.SYS).

FORMAT
        There should be one entry for each sysop, and each entry
        must be on a separate line, Blank lines, or lines beginning
        with ';' or '#' are ignored. The maximum line length is 80
        characters.

        Entries must consist of two fields separated by one or more
        spaces or tabs as follows:

                <callsign> <password>  

       <callsign> is the remote sysop's callsign without SSID.

       <password> is the password string. Must not contain spaces.

       For example: G8PZT   thisispaulaspassword
                    G1LOA   thisisrobertspassword

       Fields are not case sensitive.

NOTE
       You should try to choose a password that you can easily 
       remember, but others would find hard to guess.  It should 
       preferably be longer than 5 characters, to reduce the
       chances of someone guessing it by observing the password
       grid and your responses.

       The longer you make the password, the more secure it will
       be.  Try to avoid using well known words or names, because
       these are the favourite weapons of attack-bots. If you
       can't resist the urge to use the names of your family or
       pets, string them together to make a composite word.

       A random string is the most secure, because even if
       someone works out part of it, they won't be able to guess
       the remainder. However you must strike a balance between
       security and convenience, because while the password itself
       is never sent over the air for AX25 logins, it must be
       entered in full for an RLOGIN session.

       You may have a different password for each sysop, or you
       might choose to give all sysops the same password.
       Obviously the former is the most secure, but it's
       completely up to you.

FILES
        If present, PASSWORD.SYS must be located in the same
        directory as the XRouter executable.

SEE ALSO
        AXSCTRL(9)      -- TCP/IP Access Control.
        USERPASS.SYS(8) -- User Passwords File.

PASSWORD.SYS(8)             END OF DOCUMENT
