;***********************|****|* Max Width *|***|*********************|
PEER(7)                 XROUTER REFERENCE MANUAL             26/9/2023

NAME
        PEER -- Specify AXIP / AXUDP Link Partner.

SYNOPSIS
        PEER=<callsign>[:alias] <ipaddress | hostname> <udp_port>

DESCRIPTION
        PEER is an optional directive that may be used in certain
        types of PORT block within XROUTER.CFG. It is used to specify
        the IP addresses and UDP ports for one or more AXUDP / AXIP
        link partners.

        PEER is valid only when the PORT is attached to an INTERFACE
        which has "TYPE=AXUDP" and the PORT's IPLINK is "0.0.0.0". A
        PORT defined like this can support both AXIP and AXUDP links.
        Only ONE such port is allowed.

        This is the "alternative" way of doing AXIP / AXUDP, which is
        slighly less flexible than the "normal" (one link per port)
        method. It can be used alongside the "normal" method.

        The fields of a PEER statement may be separated by one or
        more spaces or tabs

        There is no limit to the number of PEER statements that may
        be used.

OPTIONS
        <callsign> is mandatory. It is not case-dependent. If an SSID
        is included, only packets addressed that exact destination
        will be routed. If an SSID is not included, all SSID's of the
        callsign are routed. To route packet only to G8PZT and none
        of its SSID's you would use G8PZT-0.

        [alias] is optional, and case-independent. If present, it
        allows AX25 Layer 2 connections to the partner's alias.

        <ip_address | hostname> is mandatory. Use an IP address if
        possible, because it saves having to resolve the hostname.

        <udp_port> is mandatory, but is specified as 0 for AXIP.

EXAMPLES
        # Route all SSID's of G8PZT using AXUDP, to udp port 9393
        PEER=G8PZT g8pzt.ath.cx 9393
        
        # As above, but route on either callsign or alias
        PEER=G8PZT g8pzt.ath.cx 9393
        
        # Route only to exact SSID G8PZT-14 via localhost
        PEER=G8PZT-14 127.0.0.1 10093
        
        # Route packets using AXIP instead of AXUDP
        PEER=G8PZT-0:KIDDER g8pzt.ath.cx 0

SEE ALSO
        AXIP(9)        -- AX25 over IP
        AXUDP(9)       -- AX25 over UDP
        LEARN(7)       -- Learn Unsolicited AX*P Peer Details.
        XROUTER.CFG(8) -- Main Configuration File

PEER(7)                      END OF DOCUMENT
