PEERS(1)               XROUTER REFERENCE MANUAL             25/10/2023

COMMAND
        PEERS -- Show the nearest NCMP-capable nodes.

SYNOPSIS
        PEE[rs]

DESCRIPTION
        The PEERS command displays the closest NCMP (Netrom Control
        Message Protocol)-capable neighbours, for example: 

            Nodecall   RTT  Hop  Last-cnfrmd  Last-update 
            G8PZT        0    1  26/05 04:18  26/05 04:18
            ZL2BAU-3   248    3  26/05 04:10  xx/xx xx:xx
            VK2DOT-1    31    1  26/05 04:18  xx/xx xx:xx
            G8PZT-1      6    1  26/05 03:50  26/05 03:50
            VE2PKT-4     8    1  26/05 04:17  xx/xx xx:xx
            VE3UIM-7    16    1  26/05 04:16  xx/xx xx:xx

        (For reasons of clarity, the additional fields "Latitude",
        "Longitude" and "S/ware" are not show here.)

        "RTT" is the smoothed round trip time in hundredth of a
        second, e.g "6" = 60ms. It is a running average, so it may
        show longer round trip times if traffic is heavy.

        "Hop" is the no. of hops to the peer, where "1" denotes a
        direct (netrom neighbour) link.

        "Last-cnfrmd" shows when the peer was last confirmed to be
        NCMP-capable, by the reception of any form of NCMP message
        from it. Over time, sysops may change from one brand of
        software to another, retaining the same callsign and alias.
        So it can't be assumed that a PEERS entry is valid unless
        the last-comfirmed date/time is relatively up to date. 

        "Last-update" shows the most recent time when the peer
        responded to a neighbour discovery request. 

        "S/ware" shows what software the peer is running, if known.

LIMITATIONS
        At the moment, only XRouters (XR16 / XR32 / XRLin / XRPi)
        are NCMP-capable.

        The old DOS and Windows versions of XRouter are NCMP-capable,
        so they will show up in the peers list. But they use an
        earlier version of the protocol which doesn't support the
        "last-update" feature and don't report the software version.

NOTES
        XRouter uses NCMP peers as "stepping stones" through the
        vanilla NetRom network, so that it can exchange all sorts of
        informaton that makes packet more modern, interesting and
        useful.

        If all nodes were NCMP-capable, they could pass information
        seamlessly from neighbour to neighbour. Then there would be
        no more need for neighbour discovery and the PEERS command,
        as all nodes would be peers. Like that's ever going to
        happen!

AVAILABILITY
        Sysop-only.

SEE ALSO
        NPING(1)    -- Send Netrom echo request(s)
        NTRACERT(1) -- Trace route to a netrom node.
        NCMP(9)     -- NetRom Control Message Protocol.

PEERS(1)                    END OF DOCUMENT
