PERMLINKS(9)            XROUTER REFERENCE MANUAL            18/10/2023

NAME
        PERMLINKS -- Permanent NetRom Neighbour Links.

SYNOPSIS
        This file explains why XRouter tries to keep neighbour node
        links permanently open, why that is desirable, and why you
        shouldn't worry about it.

DESCRIPTION
        Old-fashioned nodes close their AX25 level 2 links with
        neighbour nodes after a period of inactivity, which can be
        less than ideal...

        Firstly, it takes a finite time to establish an AX25 L2
        interlink from "cold", which adds an unnecessary extra
        delay for NetRom link setup, and for L3 frames which arrive
        infrequently. If it takes 5 seconds to establish a link,
        and a frame has to pass through 10 nodes, that's an extra
        50 seconds of delay!

        Secondly there is the very common and highly disruptive
        problem known as the "ONE WAY LINK".  These can occur when
        an RF path fades, or when there is local interference, or
        when a transmitter, receiver, antenna, TNC or AX*P link
        malfunctions, leaving one node hearing the other but not
        vice versa.

        When a one-way link occurs, one peer can hear the other's
        nodes broadcasts, but there is no reverse path.  The node
        which received the broadcast mistakenly thinks it has a
        route to the node which made the broadcast, but since the
        two-way path required by an AX25 connection is not
        available, no connection can be made. No traffic can be
        transferred, so the neigbour node and all nodes advertised
        by him are unreachable.

        To make matters worse, the node which received the
        broadcast advertises all the nodes learned via that
        broadcast to its other neighbours. So in turn they think
        they have routes to distant nodes, when in fact they don't.
        The network is seriously disrupted by one broken link,
        causing a black hole where all packets are LOST. This
        situation can not recover until the one way link is fixed.

        The Better Way
        ~~~~~~~~~~~~~~

        In contrast, XRouter attempts to maintain permanent L2 links
        between neighbour nodes. You may find this disconcerting,
        but it has the following advantages:

        Firstly, it removes the link establishment time, so NetRom
        traffic can be routed without delay, no matter how
        infrequently it arrives.

        Secondly, it solves the "one way link" problem by promptly
        detecting when the link cannot accept traffic, and marking
        all nodes advertised by the peer as unusable, so that
        alternative routes can be used.

        Lastly, it enables continuous measurement of route quality
        and round trip time, used in making routing decisions. RF
        links, especially long ones, can be remarkably variable
        throughout the day and night, and these problems can be
        discovered through the process of continuous link audit.

        There is no need for concern. The only cost associated with
        keeping a link open is a tiny link check packet every 3
        minutes. Hardly a great waste of bandwidth! Remember that
        the old-fashioned way has a bandwidth cost too - at least
        two packets to open a link and two to close it, in addition
        to the link check packets. The benefits of permanent links
        far outweigh the disadvantages.

        How it Works
        ~~~~~~~~~~~~

        If port QUALITY and NODESINTERVAL are both non-zero, as soon
        as XRouter hears a nodes broadcast from a previously unknown
        neighbour, it will attempt to connect to it. If the connect
        is successful, the round trip time is measured, and the
        route is considered viable. The link is checked every 3
        minutes (adjustable via T3), and will close if non-viable.

        If the connect fails, the route is marked as unusable,
        therefore no nodes will be routed via it. The connection is
        retried at regular intervals.

        If the path is marginal, connection attempts may sometimes
        succeed and sometimes fail. It is not worth using a route
        like this, so you can prevent it from re-trying by locking
        in the neighbour with a zero quality.

        The ROUTES commands will show a ">" in the left-most column
        if the interlink is fully open, a "~" if it is opening or
        closing, or an "x" if the link can't be opened or has failed.
        This  provides a handy way of detecting link problems which
        might otherwise go un-noticed.

SEE ALSO
        ROUTES(1)      -- NetRom Routes Commands.
        NODESINT(7)    -- Nodes Broadcast Interval.
        QUALITY(7)     -- Default NetRom Quality.
        XROUTER.CFG(8) -- Main Configuration File.

PERMLINKS(9)                END OF DOCUMENT
