;*************************** Max Width *******************************
PERSIST(7)             XROUTER REFERENCE MANUAL              25/9/2023

NAME
        PERSIST -- AX25 Probablity to Transmit.

SYNOPSIS
        PERSIST=n (n=0-255)

DESCRIPTION
        PERSIST is an optional PORT directive used in XROUTER.CFG.

        It specifies the AX25 "Probability to transmit" in a given
        time slot (see SLOTTIME), used as part of the CSMA channel
        access procedure, to minimise media contention.

        A low value is used when there are several stations sharing
        the channel, giving each a fair chance to transmit.  A high
        value can be used when the channel isn't shared.

        The optimum setting is 255/n  where n is the number of
        stations sharing the channel. The default is 64. 

EXAMPLES
        PERSIST=25    ; 10% probability / 10 stations
        PERSIST=128   ; 50% probability / 2 stations
        
SEE ALSO
        PERSIST(1)     -- Display / Set Port Persist.
        PORTS(6)       -- Ports in XRouter.
        SLOTTIME(7)    -- CSMA interval timer
        XROUTER.CFG(8) -- Main Configuration File.

PERSIST(7)                  END OF DOCUMENT
