PERSIST(1)              XROUTER REFERENCE MANUAL             25/9/2023

COMMAND
        PERSIST -- Display / Set the persist value for a port.

SYNOPSIS
        PER[SIST] <port> [0-255]

AVAILABILITY
        The PERSIST command is available only to sysops.

DESCRIPTION
        The PERSIST command is used to display and set the PERSIST 
        value for a port.  This is the "probability to transmit" in a
        given time slot (see SLOTTIME), used as part of the CSMA
        channel access procedure, to minimise media contention.

        A low value is used when there are several stations sharing
        the channel, giving each a fair chance to transmit.  A high
        value can be used when the channel isn't shared.

        The optimum setting is 255/n  where n is the number of
        stations sharing the channel. The default is 64. 

OPTIONS
        If the command is used with a single numeric argument, the 
        current setting for that port number is displayed.

        If two arguments are supplied, the PERSIST value for the port 
        specified by the first is set to the value of the second. 
        The new setting remains in force until changed again or until
        XRouter is restarted, in which case the value specified in
        the XROUTER.CFG file will apply.

EXAMPLES
        PERSIST 5        - Display current PERSIST value for port 5
        PERSIST 5 64     - Set port 5 PERSIST to 64

NOTE
        On KISS ports, you should allow up to 5 minutes for a new 
        setting to become active.

SEE ALSO
        PERSIST(7)     -- AX25 Probablity to Transmit.
        SLOTTIME(1) -- Display / Set CSMA interval timer
        XROUTER.CFG(8) -- Main Configuration File.

PERSIST(1)                      END OF DOCUMENT
