PING(1)                 XROUTER REFERENCE MANUAL            17/10/2023

COMMAND
        PING -- Send ICMP echo request(s).

SYNOPSIS
        PING <hostname | ipaddr> [length [interval]]

AVAILABILITY
        The PING command is available to all users except guests,
        i.e. those who access from the public Internet without using
        a password.

DESCRIPTION
        Sends ICMP echo request(s) to the specified IP address or 
        hostname for the purposes of route testing.

        An optional data portion of "length" bytes may be specified, 
        and the echo request may optionally be repeated every 
        "interval" seconds.

        If there is a reply it will be displayed.  For repeating pings 
        the system displays the number sent/rcvd, the average round 
        trip time in milliseconds, and the success rate.  The "wait 
        for reply" process may be cancelled at any time by entering 
        <CR> by itself.

        If you specify a hostname (e.g. gb7pzt.ampr.org) instead of a 
        numeric IP address the request may take longer to action if 
        the hostname isn't found in DOMAIN.SYS, because the name will 
        have to be resolved by sending a DNS request.

EXAMPLES
        PING 44.131.91.2           Single ping of minimum size
        PING 44.131.91.2 50        Single ping with 50 bytes data
        PING gb7pzt                Uses DNS to resolve host.
        PING 44.131.91.2 512 10    Ping 512 bytes every 10 secs

        The response for a single ping looks like this:

           G8PZT:KIDDER} PING: Pinging 44.131.91.2: hit <RETURN> to 
           quit...

           44.131.91.2: echo reply - rtt 495 msec

        And for a repeating ping it looks like this:

           G8PZT:KIDDER} PING:
           Target             Interval   Sent   Rcvd   %  Ave Rtt
           44.131.91.2            9955      1      1  100  880
           44.131.91.2            9955      2      2  100  880
           44.131.91.2            9955      3      3  100  880

LIMITATIONS
        The router must have an IP address and have IP routing defined 
        for this command to work.  Unrealistic ping rates are 
        prevented. The run length of a repeating ping for non-sysops
        is restricted to 5 to prevent abuse.

SEE ALSO
        GPING(1) -- Globalnet Ping
        NPING(1) -- Netrom Ping 

PING(1)                     END OF DOCUMENT
