;*************************** Max Width *******************************
PIPE(7)               XROUTER REFERENCE MANUAL               25/9/2023

NAME
        PIPE -- Frame Pipe.

SYNOPSIS
        PIPE=<destination_port_number> [callsign,callsign...]

DESCRIPTION
        PIPE is an optional PORT directive used in XROUTER.CFG.

        It creates a "frame pipe" to another port. This allows
        frames received (and optionally sent) on this port to be
        copied to another port, e.g. to allow a PMS on one port to
        see the traffic on another port.

        Unless the "bi-directional" option (see below) is specified,
        pipes are one way. In order to have two way traffic using a
        uni-directional pipe, you must set up a reverse pipe on the
        opposite port.

        You may pipe several ports to a single destination port, but
        you can only have one *outgoing* pipe from any port.

        Pipes are capable of generating an immense amount of traffic,
        so use them with care - your target port MUST be capable of
        handling the traffic load.

        By default, pipes are not selective, i.e. they pass traffic
        from any source callsign to any destination callsign (with
        the exception of Budlisted callsigns). On a busy channel,
        this could result in a lot of unnecessary traffic being piped.

        Therefore pipes can be made "selective", by adding a comma-
        delimited callsign list, e.g. "PIPE=4 GB7PZT,KDRBBS". This
        reduces the loading on the target port, by piping only the
        frames with the specified calls in the destination field.

        Pipes can also be made selective in terms of the types of
        traffic they pipe (AX25, NetRom etc). This is controlled by
        PIPEFLAG.

        Pipes can be made "bi-directional" by adding 512 to the
        PIPEFLAG value (suggested value = 515). If a frame is piped
        on a bi-directional pipe, the source call is remembered so
        that responses can be piped back to the sender. Thus a
        reverse pipe is not needed.

        Bi-directional pipes are useful where a BBS has a front end
        router - simply set up bi-directional selective pipes from
        each user port to the BBS port, and set up the BCAST option
        so that the UI mail headers are broadcast on each user port.
        The BBS will then allow direct connect and will respond to
        resync requests.

        To disable piping, set PIPE=0 or just omit the directive.

        Pipes can also be created and reconfigured during run-time,
        using the PIPE command.

EXAMPLES
        PIPE=2                ; Pipe frames from this port to port 2 
        PIPE=4 GB7PZT,KDRBBS  ; Selective pipe to port 4

SEE ALSO
        PIPE(1)        -- Display / Set "frame piping".
        PIPEFLAG(7)    -- Frame Pipe Options.
        PIPES(9)       -- About Frame Pipes.
        PORTS(6)       -- Ports in XRouter.
        XROUTER.CFG(8) -- Main Configuration File.

PIPE(7)                  END OF DOCUMENT
