;*************************** Max Width *******************************
PIPEFLAG(7)            XROUTER REFERENCE MANUAL              25/9/2023

NAME
        PIPEFLAG -- Frame Pipe Option Flags.

SYNOPSIS
        PIPEFLAG=n (where n is in the range 0 to 1023)

DESCRIPTION
        PIPEFLAG is an optional PORT directive, used in XROUTER.CFG.

        It is only used when piping is active, and controls which
        frames are piped. The default value is 3. 

OPTIONS
        The argument is the sum of the required options as follows:

             1  - UI frames *not* addressed to nodecall/alias.
             2  - Non-UI frames *not* addressed to nodecall/alias.
             4  - UI frames addressed to nodecall/alias.
             8  - Non-UI frames addressed to nodecall/alias.
            16  - UI frames transmitted by XRouter.
            32  - Non-UI frames transmitted by XRouter.
            64  - Allow budlisted users to be piped.
           128  - Netrom frames
           256  - IP / ARP frames
           512  - Bi-directional piping        

EXAMPLES
        PIPEFLAG=5        ; Pipe received UI frames only
        PIPEFLAG=517      ; Bi-directional UI pipe 

SEE ALSO
        PIPE(7)        -- Frame Pipe Directive.
        PIPEFLAG(1)    -- Display / Set Frame Pipe Options.
        PIPES(9)       -- About Frame Pipes.
        PORTS(6)       -- Ports in XRouter.
        XROUTER.CFG(8) -- Main Configuration File.

PIPEFLAG(7)                 END OF DOCUMENT
