;*************************** Max Width *******************************
PIPEFLAG(1)             XROUTER REFERENCE MANUAL             25/9/2023

COMMAND
        PIPEFLAG -- Display / Set Frame Piping Options.

SYNOPSIS
        PIPEF[lag] <port> [0-255]

AVAILABILITY
        Sysop-only.

DESCRIPTION
        The PIPEFLAG command is used to display and/or set the 
        PIPE options for a specified port.  These flags are only
        used when piping is active, and they control which frames
        are piped.

        New settings override those read from the XROUTER.CFG file,
        and remain in force until changed, or XRouter is restarted.

        The minimum abbreviation of this command is PIPEF.

OPTIONS
        The argument is the sum of the required options from this
        list:
 
             1  - UI frames *not* addressed to nodecall/alias.
             2  - Non-UI frames *not* addressed to nodecall/alias
             4  - UI frames addressed to nodecall/alias.
             8  - Non-UI frames addressed to nodecall/alias.
            16  - UI frames transmitted by XRouter.
            32  - Non-UI frames transmitted by XRouter.
            64  - Allow budlisted users to be piped.
           128  - Netrom frames
           256  - IP / ARP frames
           512  - Bi-directional piping

        The default is 3 (pipe UI and non-UI frames not addressed to
        Nodecall or Nodealias).

EXAMPLES
        PIPEF 3      Enquire current PIPEFLAG setting for port 3.
        PIPEF 4 5    On port 4, pipe received UI frames only.

SEE ALSO
        PIPE(1)        -- Display / Set Frame pipe.
        PIPEFLAG(7)    -- Frame Pipe Option Flags.
        PIPES(9)       -- About "Frame Pipes".
        XROUTER.CFG(8) -- Main Configuration File.

PIPEFLAG(1)                 END OF DOCUMENT
