PIPES(9)                XROUTER REFERENCE MANUAL            18/10/2023

NAME
        PIPES -- Frame Pipes.

DESCRIPTION
        Frame pipes allow frames received (and optionally sent) on 
        one port to be copied to another port.

        A typical use might be to allow a PMS on one port to see
        the traffic on another port, e.g. UNPROTO headers from a
        local BBS.

        Note that this is *not* the same as digipeating. With
        digipeating, the user must specify a digipeater in the path,
        but with frame piping the packets are tunneled from one port
        to another with no intervention from the user.

        The facility is enabled by including the PIPE keyword within
        a port definition, e.g. PIPE=4 would pipe frames to port 4.
        If PIPE=0, or the keyword is omitted altogether, no piping
        takes place.

SELECTIVE PIPES
        By default, pipes are not selective, i.e. they pass traffic
        from any source callsign to any destination callsign (with
        the exception of Budlisted callsigns of course). On a busy
        channel, this could result in a lot of unnecessary traffic
        being piped.

        Pipes can be made selective however, by adding a comma
        delimited callsign list, e.g. "PIPE=4 GB7PZT,KDRBBS".  This
        reduces the loading on the destination port, by piping only
        those frames with the specified callsigns in the destination
        field.

        Pipes can also be made selective in terms of the types of
        traffic they pipe (AX25, NetRom etc). This is controlled
        by PIPEFLAG (see OPTIONS below)

BIDIRECTIONAL PIPES
        A pipe normally only allows traffic in one direction, so in
        order to have two way traffic you must either set up a
        reverse pipe on the partner port, for example:

           (on port 3)    PIPE=4  ; Pipe frames to port 4
           (on port 4)    PIPE=3  ; Pipe frames to port 3

        Or you may configure the pipe to be bi-directional, by
        setting the appropriate value in PIPEFLAG (see below)

        If a frame is piped on a bi-directional pipe, the source
        callsign is remembered so that responses will be piped back
        to the sender. XRouter remembers the last 20 callsigns that
        used a pipe.

        Bidirectional pipes are useful in cases where a BBS has a
        front end router.  Simply set up bi-directional selective
        pipes from each user port to the BBS port.  The BBS will
        then allow direct connection and will respond to resync
        requests.

        Bi-directional pipes are actually only quasi-bi-directional, 
        because they can only send *responses* in the reverse
        direction.  In the above BBS example, outgoing connections
        cannot be initiated to callsigns which haven't already used
        the pipe.

        For most purposes this isn't a problem, because it is the
        users that tend to initiate the connections, not the BBS.
        However, there may be cases where the BBS needs to poll the
        user's PMS, or to initiate forwarding to another BBS. If the
        callsign is remembered from a previous session, this will
        work, otherwise it will fail. 

        The only way to have truly unconditional two-way piping is
        to set up forward and reverse pipes as detailed above.

OPTIONS
        The types of frame to be piped can be controlled using the
        optional PIPEFLAG keyword, which is ignored unless piping
        is active.

        The value for PIPEFLAG is made up by adding together the
        desired options represented by the following numbers:

            1   - UI frames *not* addressed to nodecall/alias.
            2   - Non-UI frames *not* addressed to nodecall/alias.
            4   - UI frames addressed to nodecall/alias.
            8   - Non-UI frames addressed to nodecall/alias.
            16  - UI frames transmitted by the router.
            32  - Non-UI frames transmitted by the router.
            64  - Allow budlisted users to be piped.
            128 - Netrom  & nodes broadcast frames.
            256 - IP / ARP frames.
            512 - Bi-directional piping.

        e.g. PIPEFLAG=5 will pipe all received UI frames, but not
        those which originated from XRouter itself.

        If PIPEFLAG is not specified, the default value is 3, which
        pipes all regular AX25 Layer 2 traffic.  You are *STRONGLY*
        recommended to use the default value unless you specifically
        need to see additional traffic.

LIMITATIONS
        You may pipe several ports to a single destination port, but
        you can only have one *outgoing* pipe from any port.

CAVEATS
        Pipes are capable of generating an immense amount of traffic,
        so use them with care - your target port MUST be capable of
        dealing with the traffic load, and you should avoid setting
        up a combination of pipes which might cause an endless loop!

FILES
        The PIPE and PIPEFLAG directives are used in the PORT
        sections of XROUTER.CFG.

SEE ALSO
        PIPE(1)        -- Display / Set Frame pipe.
        PIPEFLAG(7)    -- Frame Pipe Option Flags.
        BCAST(9)       -- Frame Broadcasting.
        XROUTER.CFG(8) -- Main Configuration File

PIPES(9)                    END OF DOCUMENT
