PMS(9)                  XROUTER REFERENCE MANUAL              10/1/2024

NAME
        PMS -- Personal Message Server / Mailbox.

SYNOPSIS
        This file describes XRouter's inbuilt mailbox which can be
        used for both private messages and bulletins. The terms "PMS"
        and "mailbox" are used interchangeably.

DESCRIPTION
        XRouter's mailbox is a no-frills message storage and retrieval
        system which was originally intended for exchanging messages
        between users and the sysop, hence the legacy name PMS.

        The mailbox understands SIDs (System IDentifiers), MIDs
        (Message IDentifiers) and BIDs (Bulletin IDentifiers),
        hierarchical addressing, bulletins, MBL forwarding and reverse
        forwarding, so it can also be used to exchange private mail
        and bulletins with a full-service Bulletin Board System
        (BBS). In fact it is a mini-BBS in its own right, as users
        may leave bulletins for others to read.

        There is no limit to the number of messages or the size of a 
        message.  If a disk is available, messages are stored on the
        disk and will persist until killed, or expired by age. If no
        disk is available, messages are stored in RAM and will be lost
        if XRouter is restarted.

        If there is unread private mail addressed to the sysop, the
        latter is alerted by "PMS" flashing to the left of the node
        callsign on the top status bar.

BASIC CONFIGURATION
        The mailbox can be configured in one of several "modes"
        controlled by the PMSTYPE directive in XROUTER.CFG. The
        default is mode 1 i.e. standard PMS. To configure the mailbox
        as a full BBS instead, use PMSTYPE=4. See the section 7 page
        for PMSTYPE.

        The mailbox is always available from the node's command line,
        but if you want to enable "direct" AX25 connections, you must
        configure at least PMSCALL in XROUTER.CFG.

        If you want your mailbox to be visible on the NetRom networ
        as well, you must additionally add PMSALIAS and a non-zero
        PMSQUAL. For example: 

                PMSCALL=G8PZT-2
                PMSALIAS=PZTPMS
                PMSQUAL=50

        If you plan to exchange mail with other systems, you must set
        the PMSHADDR directive in XROUTER.CFG. Also note that the
        agreed specification for mail forwarding does not allow SSID's
        in mailbox callsigns, so even if PMSCALL includes an SSID, the
        mailbox "identity", as far as the mail forwading system is
        concented, is PMSCALL without SSID.

        Additional configuration options can be specified in PMS.CFG,
        which is explained in its own section 8 MAN page.

CONNECTING TO THE MAILBOX
        Whatever the setting of PMSTYPE, the mailbox can always be   
        accessed using the "PMS" command or by a connection to
        NetRomX service 2.

        If PMSTYPE=4, the mailbox is accessed via the "BBS" command
        instead. If the "PMS" command is used in this mode, only
        personal mail is shown by default.

        In addition, if PMSCALL is defined in XROUTER.SYS, users may
        perform an AX25 level 2 connect directly to the PMSCALL.
        (PMSCALL must not not be the same as NODECALL)

        If PMSALIAS and a suitable PMSQUAL are also defined, users may 
        also connect directly to the mailbox from another node, using
        "legacy" NetRom.

        At the time of writing there is no direct TCP/IP access to the
        the PMS, because a regular Telnet connection followed by the
        issuing of the "PMS" command is sufficient.
        
COMMANDS
        The mailbox has its own rudimentary command set, separate from
        the node commands. The following is a possibly incomplete list.
        (A full list can be obtained using the command "? **")

           <n> [n1 n2..]   Read message(s)
           ? [*]           Syntax and brief help
           A[bort]         Aborts paused message reading/listing
           B[ye]           Disconnect from the PMS.
           CB <cat> [dist] Copy any type of message to a bulletin
           CP <to> [at]    Copt any type of message to a private msg 
           EH <msgnum>     Edit header fields for <msgnum> (*3)
           EX[port] <n> <file> Export msg <n> to <file>  (*3)
           H[elp]          Display list of commands.
           HO[ld] <msg>    Hold a message (*3)
           FF              Force Forwarding run (*3)
           FP              Force Polling run (*3)
           H[elp] [topic]  Display help for PMS command or topic
           I[nfo] <call>   Display all WP info for <call>
           I@ <bbs>        List users with <bbs> as their 'home' BBS
           IC <call>       List users with pallsign <call> (*1)
           IH <haddr>      List users at hierarchical address <haddr>
           IM[port] <file> Import message(s) from MBL-format file (*3)
           IN <name>       List users called <name> (*1)
           IQ <qth>        List users at <qth> (*1)
           IZ <zip>        List users at <zip> / locator (*1)
           J [max]         Show most recent [max] callers (default 10)
           K[ill] <n ...>  Kill one or more messsages
           K> <call>       Kill messages TO <call> (*1)(*2)
           K< <call>       Kill messages FROM <call> (*1)(*2)
           K@ <dist>       Kill messages AT <distribution> (*3)
           KF [call]       Kill Forwarded msgs [TO call] (*1)(*3)
           KH [call]       Kill Held msgs [TO call]  (*1)(*3)
           KM              Kill Mine (messages you have read)
           KR [call]       Kill Read messages [TO call] (*1)(*3)
           L[ist]          List messages and bulletins.
           L[ist] <n>      List messages starting at number <n>
           L[ist] <f> <l>  List messages from numbers <f> to <l> 
           L> <to>         List messages TO callsign or category
           L< <from>       List messages FROM callsign
           L@ <at>         List messages AT a distribution
           L$ [to]         List messages waiting to be forwarded
           LA <n>          List oldest <n> messages (same as LO)
           LB [n]          List [max of n] Bulletins backwards
           LC [cat]        List bulletin categories (*1)
           LF [to]         List sucessfully Forwarded messages
           LH              List held messages (*3)
           LL <n>          List the Last (most recent) <n> messages 
           LM              List Mine (all messages addressed to you)
           LN              List New (unread) mail addressed to you
           LO <n>          List oldest <n> messages (same as LA)
           LP [n]          List [max of n] Private messages
           LR [to]         List private mail that has been read
           LS <text>       List messages whose subject contains <text>
           LT <text>       List messages containing <text> in body
           LU [to]         List Unread messages
           M[ine]          List messages sent by you
           MB <file> <cat> Make Bull from file to category <cat> (*3)
           MF <n> <file>   Make File from message <n> (*3)
           MFH <n> <file>  Make File from message, incl headers (*3)
           MP <file> <to>  Make Private message from a file (*3)
           N[ext]          Read next message in a "reading list"
           N[ame] [name]   Display or set your name in White Pages
           NC [on | off]   Display/set your ANSI colour preference
           NH [bbs]        Display or set your Home BBS
           NI              Summary of your user record
           NP [lines]      Set pagination [0=off]
           NQ [qth]        Display or set your QTH
           NZ [zip]        Display or set your Zip / Locator
           Q[uit]          Stop reading a list of messages
           R> <to>         Read messages TO callsign or category
           R< <from>       Read messages FROM callsign
           R@ <at>         Read messages AT a distribution
           R[ead] <n ...>  Read msg(s), hiding routing headers.
           RH <n ...>      Read message(s) showing routing headers
           RM              Read Mine (all messages addressed to you)
           RN              Read New (unread) mail addressed to you
           S[end]          Send a message to sysop.
           SB <topic>      Send bulletin to <topic>
           SF              Stop Forwarding run (*3)
           SP <call>       Send personal message to <call>
           SR              Send Reply to a message you just read
           U[nread] <msg>  Unread a message (mark it unread) (*2)
           UH <n n | all>  Un-hold one or more "held" messages (*3)
           VF              View Forwarding queue (*3)

           (*1) Wildcards are allowed.
           (*2) Non-sysops can only action their own messages.
           (*3) Sysop-only

MESSAGE STATUS
        Messages have a "status" indicator as follows:

           Status ' ' indicates unread "local" private mail.
           Status '$' indicates unforwarded non-local mail.
           Status 'F' indicates forwarded non-local mail.
           Status 'R' indicates local private mail that has been read.
           Status 'H' indicates that the message is "held".

DISCONNECTING
        To exit the mailbox, the user may send BYE or QUIT, or simply
        disconnect.

        Users who accessed the mailbox via the "PMS" or "BBS" commands
        are returned to  XRouter's "node" command prompt upon receipt
        of BYE or QUIT. Users who accessed via any other method are
        disconnected by these commands.

FILES
        Messages are stored as individual files in the PMS
        sub-directory of the XRouter working directory. 

        If PMSTYPE=4 (full BBS) the PMS directory may also contain
        other files which control BBS operations, such as PMS.CFG,
        BADWORD.SYS, DISTRIB.SYS, EXPORT.SYS, FWD.SYS, HOLD.SYS, and
        REJECT.SYS. Their purpose is as follows:

        BADWORD.SYS   List of "bad" words which cause message hold.
        DISTRIB.SYS   Controls distribution of mail to other BBS's
        EXPORT.SYS    Controls exporting of messages to files
        FWD.SYS       Controls "forwarding" & "polling" operations
        HOLD.SYS      Controls message "holding"
        PMS.CFG       Additional configuration info
        REJECT.SYS    Controls rejection of unwanted mail.

        Most of these plain text files contain their own
        documentation.
        
HOUSEKEEPING
        Optionally takes place at regular intervals (e.g. every 24
        hours - specified on PMS.CFG), when the PMS is idle.

        During this operation, out of date messages and message ID's
        are purged, and (if configured to do so) the  message base is
        re-numbered to remove gaps and keep the message numbers
        within a sensible range

MAIL IMPORT
        At intervals less than a minute, the PMS will check the PMS
        directory for the existence of a file called "mail.in". If the
        file exists, the mail it contains is imported and the file is
        deleted. Don't write directly to "mail.in" otherwise it might
        be imported before you finish writing it. Create the file with
        a different name, then rename it to "mail.in" when completed.

MAIL EXCHANGE
        This is a two-part process, the parts being DISTRIBUTION and
        FORWARDING. The former is controlled by DISTRIB.SYS, and the
        latter by FWD.SYS.

        Distribution is the process of queuing mail for onward
        transmission to neighbouring mail handlers, and is an
        instantaneous process, executed upon receipt of incoming mail.

        Forwarding is the process of connecting to neighbouring mail
        handlers, and sending the queued mail to them. It is a
        background process, which can optionally be initiated when
        mail is queued, or deferred until later.

NOTE
        If a command alias, or an application, with the name "PMS" is 
        defined, it takes priority over the internal PMS.

AVAILABILITY
        The PMS is available to all users. It is also available via
        the HTTP interface. Some functionality is available via REST
        and MQTT interfaces.

SEE ALSO
        PMS(1)      -- Start PMS Session.
        PMSALIAS(7) -- PMS Alias
        PMSCALL(7)  -- PMS Callsign.
        PMSHADDR(7) -- PMS Hierarchical Address.
        PMSQUAL(7)  -- PMS Quality.
        PMSTYPE(7)  -- PMS Mode.
        PMS-SVC(9)  -- NetRomX PMS Service
        MQTT-PMS(9) -- MQTT Interface to PMS.
        REST-PMS(9) -- REST Interface to PMS.

PMS(9)                      END OF DOCUMENT
