;***********************|****|* Max Width *|***|*********************|
PMS.CFG(8)              XROUTER REFERENCE MANUAL             29/3/2024

NAME
        PMS.CFG -- PMS / BBS Configuration File.

DESCRIPTION
        PMS.CFG is an optional configuration file for the inbuilt
        mailbox. If present, it is located in the PMS folder. It is
        read only when the program starts.

        It is a text file containing directives of the general form
        <keyword>=<value>, each on a separate line.  Keywords are
        not case sensitive, and they may be specified in any order. 

        Blank lines and comment lines are allowed. The latter must
        begin with a semicolon (;) or hash (#) in the leftmost
        column.  Lines must not exceed 255 characters.

        If PMS.CFG is not present, the mailbox uses default values.

OPTIONS
        The options currently recognised are as follows:

        SysopCallsign
            Sysop's callsign (defaults to PMSCALL without SSID)
  
        HousekeepInterval
            Hours between "housekeeping" sessions (default 24).
            Housekeeping removes old messages, optionally re-numbers
            the messages to remove gaps, and generates WP updates.

        ForwardInterval
            Seconds between Forwarding "runs" (default 900)
            If set to 0, forwarding is triggered only upon receipt of
            mail

        FwdKickOnRcv
            If set to 1 (default) a forwarding "run" is triggered
            immediately upon receipt of new mail. If set to 0,
            forwarding is deferred until next "run" is due

        AutoRenumber
            Controls re-numbering of messages at housekeep time.
            If it is non-zero, messages are renumbered if the highest
            message number exceeds the specified value. e.g. a value
            of 5000 means that messages are not renumbered until the
            highest number is equal to, or greater than 5000.
            After renumbering, message numbers start at 1 with no
            gaps. Default is 0 = no renumbering.

        MaxAgeB
            Maximum lifefime in days for a bulletin (default 30)

        MaxAgePR
            Maximum lifetime for private mail that has been read.
            (default 180)

        MaxAgeMid=30
            Maximum lifetime for message identifiers (default 30)

        WpUpdateTo
            Callsign (without SSID) of neighbour BBS to whom WP
            updates are to be sent. Can be used multiple times, to
            specify more than one BBS. The default is none, i.e.
            don't send WP updates.

EXAMPLES
        ForwardInterval=3600
        FwdKickOnRcv=0
        WpUpdateTo=GB7PZT

SEE ALSO
        PMS(1)         -- Access Personal Message System(s).
        PMS(9)         -- About the PMS.
        XROUTER.CFG(8) -- Main Configuration File.

PMS.CFG(8)                   END OF DOCUMENT
