PMSALIAS(7)            XROUTER REFERENCE MANUAL              25/9/2023

NAME
        PMSALIAS -- Alias for Personal Mail System.

SYNOPSIS
        PMSALIAS=<alias>

DESCRIPTION
       PMSALIAS is a directive that can be used in XROUTER.CFG,
        both "globally" and within PORT definition blocks.

        It specifies an "alias", i.e. a sort of memorable alternative
        "callsign" for the PMS, e.g. "IOWPMS" (Isle of Wight
        PMS). This can be used interchangeably with the PMSCALL;
        i.e. the PMS will respond to either.

        The <alias> is a string of up to 6 uppercase ASCII characters
        and numbers. It is suggested that it should end with "PMS",
        and begin with the last 3 letters of the sysop's callsign.

        Alternatively, if the PMS is being used as a public BBS, you
        could use something geographically relevant, e.g. BHMPMS for
        Birmingham, KDRPMS for Kidderminster etc., so it can be
        easily identified in node tables.

        If used "globally", it specifies the "primary" PMS alias,
        used for AX25, NetRom and TCP operations.

        Any PORTs declared further down XROUTER.CFG "inherit" this
        alias for AX25 Layer 2 PMS operation on that port, UNLESS
        overridden by the use of PMSALIAS within that PORT's
        definition block.

        If PMSALIAS is used within a PORT definition block, it
        replaces the "global" PMS alias for that port only.

EXAMPLES
        PMSALIAS=IOWPMS
        PMSALIAS=PZTPMS

CAVEATS
        Omitting the global PMSALIAS, or setting it IDENTICAL to
        NODEALIAS disables PMS NetRom connectivity, but the PMS
        can still be used "standalone" via the PMS command.

SEE ALSO
        PMS(1)         -- Start PMS Session.
        PMS(9)         -- Personal Mail Server.
        PMSCALL(7)     -- PMS Callsign.
        PMSQUAL(7)     -- NetRom Quality for PMS.
        PORTS(6)       -- Ports in XRouter.
        XROUTER.CFG(8) -- Main Configuration File.

PMSALIAS(7)                  END OF DOCUMENT
