;*************************** Max Width *******************************
PMSCALL(7)             XROUTER REFERENCE MANUAL              24/9/2023

NAME
        PMSCALL -- Callsign for Personal Message System.

SYNOPSIS
        PMSCALL=<callsign>

DESCRIPTION
        PMSCALL is a directive that can be used in XROUTER.CFG,
        both "globally" and within PORT definition blocks.

        It specifies the AX25/NetRom callsign for the Personal
        Message / Mailbox System (PMS). This can be used
        interchangeably with the PMSALIAS; i.e. the PMS will
        respond to connections directed at either.

        If used "globally", PMSCALL specifies the "primary" PMS
        callsign, used for AX25 and NetRom operations. This can be
        the same as NODECALL, but MUST use a different SSID. A SSID
        of -2 is the de-facto standard for XRPMS systems.

        Any PORTs declared further down XROUTER.CFG "inherit" this
        callsign for AX25 Layer 2 PMS operation on that port,
        UNLESS overridden by the use of PMSCALL within that PORT's
        definition block.

        If PMSCALL is used within a PORT definition block, it
        replaces the "global" PMS callsign for that port only.

EXAMPLE
        PMSCALL=G8PZT-2

CAVEATS
        Omitting the global PMSCALL, or setting it IDENTICAL to
        NODECALL (including the SSID) disables PMS server
        connectivity, but the PMS can still be used "standalone"
        via the PMS command.

SEE ALSO
        PMS(1)         -- Start PMS Session.
        PMS(9)         -- About the Personal Message System.
        PMSALIAS(7)    -- Personal Message System Alias.
        PMSQUAL(7)     -- NetRom Quality for PMS.
        PORTS(6)       -- Ports in XRouter.
        XROUTER.CFG(8) -- Main Configuration File.

PMSCALL(7)                  END OF DOCUMENT
