;***********************|****|* Max Width *|***|*********************|
PMSTYPE(7)              XROUTER REFERENCE MANUAL             29/3/2024

NAME
        PMSTYPE -- Set PMS / BBS mode.

SYNOPSIS
        PMSTYPE=n (n=0-4)

DESCRIPTION
        PMSTYPE is an optional directive, which can be used anywhere
        within the "global" section of XROUTER.CFG. If present, it
        specifies the type, or mode, of the inbuilt mailbox. If not
        present, the mode defaults to 1 (standard PMS).

        The purpose of this is to allow the sysop to comply with
        their local licensing regulations and/or to have some
        control over what their system is doing.

OPTIONS
        0  Reserved for possible "No bulletins" option.
        1  Normal PMS, reverse forwarding only (default)
        2  PMS with forwarding and reverse forwarding.
        3  PMS with forwarding, reverse forwarding & relaying
        4  Full BBS

        The "Standard PMS" option accepts incoming mail (including
        bulletins) from bulletin boards, and allows outgoing mail to
        be collected by them. It also allows automatic XRouter to
        Xrouter private mail forwarding. It does not allow the
        mailbox to initiate "conventional" forwarding to other
        systems.

        Mode 2 allows "conventional" forwarding and reverse
        forwarding, but does not allow "relaying", i.e. mail
        received from one BBS cannot be forwarded to another.

        Mode 3 is a "sleeper" BBS. It looks and acts like a BBS, but
        pretends to be a PMS. It is still accessed using the PMS
        command.

        Mode 4 changes some of the captions, and installs the "BBS"
        command (in addition to the PMS command). If accessed via the
        former, both bulletins and personal mail are displayed by
        default. If accessed via the PMS command, only personal mail
        is displayed by default. 

EXAMPLES
        PMSTYPE=1  - Normal PMS
        PMSTYPE=3  - BBS masqurading as a PMS

SEE ALSO
        PMS(1)         -- Access Personal Message System(s).
        PMSHADDR(7)    -- Hierarchical Address of PMS.
        PMS.CFG(8)     -- PMS Configuration File.
        PMS(9)         -- About the PMS.
        XROUTER.CFG(8) -- Main Configuration File.

PMSTYPE(7)              END OF DOCUMENT
