;*************************** Max Width *******************************
PORTS(6)               XROUTER REFERENCE MANUAL              26/9/2023

NAME
        PORTS -- PORTS in XRouter.

DESCRIPTION
        A PORT is a point of interaction between XRouter's central
        "core" and the INTERFACES which connect to the world outside
        XRouter. You cannot have a PORT without having an INTERFACE
        to attach it to.

        All AX25 operations are PORT-based, where a PORT usually
        corresponds to a single radio frequency. Ports allow XRouter
        to direct output to a specific device, and receive input
        from that device.

        Each port is "attached" to a CHANNEL on an INTERFACE. Some
        interfaces are single-channel, and can therefore support only
        one PORT. Others are multi-channel, and can have several
        ports attached to them.

        For example, an ASYNC interface connected to a PSTN modem
        supports only one channel of communication with the modem,
        therefore it can only support one port. But an ASYNC
        interface using KISS protocol can support a multi-channel
        TNC, whereby each channel is connected to a seperate radio on
        its own frequency, thus there would be one PORT for each
        channel.

        For historical reasons, XRouter will not run unless there is
        at least one PORT.

        Defining Ports in XRouter:
        ~~~~~~~~~~~~~~~~~~~~~~~~~~

        XRouter ports are configured using PORT definition blocks
        within the GLOBAL section of XROUTER.CFG. The blocks start
        with the keyword PORT and end with ENDPORT.

        They contain "directives" of general form <keyword>=<value>,
        each on a separate line. (If you do not understand the
        significance of the <>, please see the conventions section).
        Keywords are not case sensitive, and may be specified in any
        order.

        For example:

            PORT=2
                (directives here)
            ENDPORT

        Some directives are mandatory, but most are optional. The
        full range of port keywords is summarised below: 

OPTIONS

        PORT Keywords - Overview (*=mandatory)
        ~~~~~~~~~~~~~~~~~~~~~~~~

        APPLMASK        Controls which applications are visible
        APRSPATH        Default digipeater path for APRS
        BCAST           List of destinations for "broadcasting"
        BCFROM          Callsigns who may broadcast
        CFLAGS          Controls AX25 up/downlinking
        CHANNEL         Channel to use on interface (A)
        CHATALIAS       Port override for global chatalias
        CHATCALL        Port override for global chatcall
        CTEXT           Text to send to incoming connectees
        CTFLAGS         Controls who gets the CTEXT
        CWID            Text to send in CW every 30' (SCC only)
        DHCP            Enables / disables DHCP client (0)
        DIGIFLAG        Controls digipeating (7)
        DIGIPORT        Port to digipeat on (this port)
        DYNDNS          Enable / disable Dynamic DNS update client
        ENDPORT       * Ends port definition block
        EXCLUDE         List of callsigns not allowed to connect
        FEC             Enable / disable Forward Error Correction (0)
        FRACK           AX25 Frame Acknowledgement time ms (7000)
        FREQUENCY       Radio frequency in Hz (0).
        FULLDUP         Allow simultaneous TX/RX (SCC only)
        ID            * Text to identify port on ports display
        IDPATH          Dest & digi path for ID beacons ("ID")
        IDTEXT          Port override for global IDTEXT
        INITSTR         Modem initialisation string (modem only)
        INTERFACENUM  * Interface number this port is bound to
        INTERLOCK       Prevents simultaneous TX on SCC cards
        IPADDRESS       Port override for global IP address
        IPLINK          IP address / hostname of AXIP/AXUDP peer
        MAXFRAME        Max outstanding AX25 L2 frames (3)
        MAXHOPS         Port override for global MAXHOPS
        MAXTT           Port override for global MAXTT
        MHEARD          Enable / disable MHeard on this port
        MHFLAGS         Controls contents of MHeard list (255)
        MINQUAL         Port override for global MINQUAL
        MINTXQUAL       Min NetRom quality to broadcast
        NETMASK         Subnet mask used with IPADDRESS
        NODESINTERVAL   Port override for global NODESINTERVAL
        PACLEN          Port override for global PACLEN
        PERSIST         Probability to transmit 0-255 (64)
        PIPE            Creates a "frame pipe" to another port
        PIPEFLAG        Controls frame piping (3)
        PMSALIAS        Port override for global PMSALIAS
        PMSCALL         Port override for global PMSCALL
        PORTALIAS       Port override for global NODEALIAS
        PORTALIAS2      Secondary alias for digipeating only.
        PORTCALL        Port override for global NODECALL
        PROXY           NetRom systems to tunnel AX25 to
        QUALITY         Default NetRom neighbour quality (10)
        RESPTIME        AX25 delayed ack timer in ms (2000)
        RETRIES         Max connect/disconnect/resent attempts (10)
        RFBAUDS         RF baud rate (1200)
        SESSLIMIT       Max simultaneous connections per user (255)
        SLOTTIME        CSMA interval timer (millisecs) (100)
        SOFTDCD         Use software DCD (SCC only) (0)
        SYSOP           If 1, all users on this port are sysops (0)
        TXDELAY         Delay (ms) between PTT and start of data (300)
        TXPORT          Port on which to TX if not this one (0)
        TXTAIL          Delay (ms) between data end and PTT drop (100)
        UDPLOCAL        RX UDP port for AXUDP operations (93)
        UDPREMOTE       TX UDP port / Partners AXUDP RX port (93)
        UNPROTO         Dest & digi calls for unproto broadcasts
        USERS           Max simultaneous users on this port (255)
        VALIDCALLS      Only these callsigns allowed to connect.

        For more information on each of the above keywords, please
        refer to its page in section 7 of the manual.

EXAMPLES
        a) KISS Port, no NetRom, Pipe to port 7:
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        User-access frequency, hence NetRom linking is suppressed by
        zero QUALITY. Note the bi-directonal selective UI pipe to a
        BBS which is on port 7, allowing FBB resync requests, and the
        use of BCAST for broadcasting the BBS's mail beacons onto this
        port.

            PORT=1
                ID=144.850 MHz 1200 baud users
                INTERFACENUM=1   ; Multi-drop KISS interface
                CHANNEL=C        ; 3rd TNC
                PACLEN=160       ; Larger than default
                MAXFRAME=2       ; Smalled than default
                TXDELAY=400      ; Synth rig takes time to tx
                QUALITY=0        ; Disable NetRom on this port
                BCAST=MAIL       ; Allow mail beacons from BBS
                BCFROM=GB7PZT    ; BBS call allowed to Bcast
                PIPE=7 GB7PZT    ; Selective pipe to BBS
                PIPEFLAG=513     ; Bi-directional, UI-only
            ENDPORT


        b) APRS-only port:
        ~~~~~~~~~~~~~~~~~~

        Note the use of comment lines, an alternate IDTEXT, and the
        use of CFLAGS to disable connected mode operations, thus
        MAXFRAME, FRACK, PACLEN etc. are not needed.

            PORT=13
                ID=144.800 MHz 1200 baud APRS
                INTERFACENUM=1   ; Multidrop KISS interface
                CHANNEL=B        ; 2nd TNC
                CFLAGS=0         ; Prevent up/downlinks on this port
                DIGIFLAG=5       ; Digi only UI frames via RELAY
                MHEARD=22        ; Nice big MH list
                IDTEXT=!5224.00N/00215.00W#PHG3021 Kidder APRS digi
                ;
                ; Override default destination & path for ID beacons
                IDPATH=APRS,RELAY,WIDE
                ;
                ; Default digipeater path for APRS frames originated
                ; by APRS messaging shell and Igate.                 
                APRSPATH=RELAY
                ;                
            ENDPORT


        c) AXIP Port:
        ~~~~~~~~~~~~~

        Note the use of lower FRACK and RESPTIME because it is a
        faster link.

            PORT=8
                ID=AXIP link with WA3IP
                INTERFACENUM=2     ; Points to an AXIP interface
                IPLINK=55.73.88.69
                FRACK=2000
                RESPTIME=200
            ENDPORT


        d) AXUDP Port:
        ~~~~~~~~~~~~~~

        Illustrates the use of non-standard UDPLOCAL and UDPREMOTE, a
        hostname for IPLINK, plus lower FRACK and RESPTIME because it
        is a fast link.

            PORT=9
                ID=AXUDP link with VK1UDP
                INTERFACENUM=3           ; AXUDP interface
                IPLINK=vk1udp.ath.cx
                UDPLOCAL=9393            ; Non-standard
                UDPREMOTE=10093          ; Non-standard
                FRACK=2000
                RESPTIME=200
            ENDPORT

SEE ALSO
        IFACES(6)      -- Interfaces in XRouter.
        PORTSMORE(6)   -- PORT Directives in More Detail.
        XROUTER.CFG(8) -- Main Configuration File.

PORTS(6)                  END OF DOCUMENT
