PORTS(1)              XROUTER REFERENCE MANUAL               10/9/2023

COMMAND
        PORTS -- Display / Edit the ports.

SYNOPSIS
        P[orts]
        P[orts] A[dd] <portnum> <ifacenum> <id>
        P[orts] D[rop] <portnum>
        P[orts] L[ist]
        P[orts] S[tart] <portnum> 

DESCRIPTION
        The PORT[s] command, which may be abbreviated to "P". can
        be used to add, remove and list the communication ports.

OPTIONS
        "P[ports]" and "P[orts] L[ist]" have identical function.
        They display XRouter's port numbers along with their brief 
        descriptions as specified by the PORTID fields in the CFG 
        file.

        The "ADD" sub-command is used to create a new PORT, using
        the INTERFACE (which must already exist) specified by
        <ifacenum>, and having a PORTID specified by the <id> field.
        The new port is not operational until after a "PORT START"
        command (see below). This allows for the port parameters to
        be set up and adjusted without affecting anything else. 

        The "START" sub-command starts operations on the port. If
        anything is seriously wrong it will complain, allowing the
        configuration to be changed bfore attempting START again.

        The "DROP" sub-command stops and removes a port. 

AVAILABILITY
        The basic "PORTS" command is available to all users, but the
        ADD and DROP and START sub-commands are sysop-only.

NOTES
        The lack of a STOP sub-command is deliberate, to prevent
        ports being stopped and forgotten about.

CAVEATS
        Starting and stopping ports on a system with so many hardware
        and protocol combinations is horrendously complex. It is not
        practicable to test all combinations prior to release,
        therefore this cannot be guaranteed to be bug free. Please
        report any issues, so they can be corrected.

PORTS(1)                      END OF DOCUMENT
