PORTSMORE(6)            XROUTER REFERENCE MANUAL            23/10/2023

NAME
        PORTSMORE -- Port Directives In More Detail.

SYNOPSIS
        This document gives more detail on each of the PORT
        directives listed in PORTS(6). Each of these directives has
        its own section 7 MAN page, which in some cases may give
        even more detail.

APPLMASK
        Used only if XRouter is hosting applications, e.g. via the
        DEDHOST interface. Controls which applications are directly
        connectable on a given port. The default is 255, which allows
        all applications. The value is made up by adding together the
        desired selection from the following numbers:

                  1  - Enable Application 1
                  2  - Enable Application 2
                  4  - Enable Application 3
                  8  - Enable Application 4
                 16  - Enable Application 5
                 32  - Enable Application 6
                 64  - Enable Application 7
                128  - Enable Application 8

        For example, if a port's definition contains "APPLMASK=9", it
        will only allow direct connections to applications 1 and 4 on
        that port, and only if those applications have either an
        APPLCALL or an APPLALIAS. 

APRSPATH
        Default digipeater path for APRS frames originated by APRS
        messaging shell and IGATE. If you omit this, the frames will
        be sent without any digipeaters. Messaging shell users may
        override this path.

        Example: APRSPATH=RELAY 

BCAST
        List of destinations for "UI broadcasting". Received non-
        digipeater UI frames, addressed to one of these destinations,
        are re-broadcasted on all ports which have a matching address
        in their BCAST list, e.g. to broadcast mail beacons from a
        BBS on one port onto several other ports.

        The callsigns must be separated by commas and there should be
        no spaces in the list.

        Example: BCAST=MAIL,ALL 

BCFROM
        Specifies a list of callsigns who may use the UI broadcast
        facility (see BCAST). BCFROM applies only to frames
        *directly* received on the port for which it is specified
        (i.e. not via digipeaters).

        If you wish to restrict the broadcast facility to certain
        senders only, list the callsigns here. If no calls are 
        specified, the facility is unrestricted. Separate the calls
        by commas, and don't include any spaces in the list.

        Example: BCFROM=GB7PZT,GB7MAX 

CFLAGS
        Controls whether or not AX25 level 2 uplinking and/or
        downlinking is allowed on the port. A typical use may be to
        prevent users from uplinking and downlinking on APRS-only
        ports. It also allows the sysop to control whether or not
        L3RTT frames are generated on inter-node links, and whether
        or not AX25 level 2 fragmentation is allowed on the port.

        Add together the decimal values of the desired options from
        this list:

                Val   Function
                -------------------------------------------------
                 1  - Allow incoming connections (uplinks).
                 2  - Allow outgoing connections (downlinks).
                 4  - Applications may downlink unconditionally.
                 8  - Suppress L3RTT generation.
                16  - Allow L2 fragmentation.

        The default value is 3, i.e. unconditional use of the port.

        Irrespective of the setting of CFLAGS, the Sysop can always
        downlink.

        Bit 2 allows applications to downlink unconditionally, i.e.
        even if users are prevented from downlinking.

        Bit 3 was provided to keep the Luddites happy, but its use
        is strongly deprecated. Setting this flag prevents L3RTT
        frames from being originated by the port if it is carrying
        an inter-node link. It will not prevent XRouter from trying
        to hold inter-node links open, as that is too much of a
        retrograde step! This bit is not set by default.  Note that
        L3RTT may also be suppressed if a route's MAXTT is 65535.

        Bit 4 allows AX25 layer 2 fragmentation if it is set. This
        is required if Forward Error Correction (FEC) is in use, to
        allow big L3 frames to be sent.

        Examples:

                CFLAGS=2  - Allow downlinking only
                CFLAGS=5  - Allow only sysops and apps to downlink.

CHANNEL
        Channel to use on interface (A-P), required only on certain
        types of multi-channel interface, e.g. KISS. Not required on
        AXIP, AXUDP, or AXTCP interfaces. Default is A.

        Example: CHANNEL=C 

CHATALIAS
        Port override for global CHATALIAS. If specified, the chat
        server will use this alias instead of the global CHATALIAS,
        on this port only.

        Example: CHATALIAS=KDRCH2 

CHATCALL
        Port override for global CHATCALL. If specified, the chat
        server will use this callsign instead of the global CHATCALL,
        on this port only.

        Example: CHATCALL=G8PZT-9 

CTEXT
        Port override for global CTEXT. This is a single line of text
        that can be sent to a caller when they connect to XRouter.
        The companion directive CTFLAGS controls which callers
        receive the text.

        If the argument specifies a filename, the contents of that
        file are read "live" every time someone connects, which may
        be of use in EMCOMM scenarios. The specified file could for
        instance be updated by another program, such as an extreme
        weather detector. See CTEXT(7) for more details.

        Examples:
            CTEXT This port is for linking only
            CTEXT /etc/weather/latest.txt

CTFLAGS
        Controls which callers are sent a "connect text" (CTEXT) when
        they connect to XRouter.

        The argument is the sum of the desired options from the
        following list:

           1 - Send CTEXT upon connection to PORTALIAS.
           2 - Send CTEXT upon connection to PORTCALL.
          
        The default value is 1 (Alias only).

CWID
        Text to send in Morse Code every 30', used only by SCC ports.
        It specifies a callsign (8 characters max.) which is sent
        every 30 minutes using Morse code. If omitted, no cwid is
        sent.

        Example: CWID=G8PZT 

DHCP
        Specifies whether or not the port IP address is obtained
        dynamically using DHCP (DHCP=1) or specified statically
        (DHCP=0). Default is 0. 

DIGIFLAG
        Controls digipeating (0=none, default=7). Options are
        enabled by adding together the following numbers:

                Value Option
            ---------------------------------------------------
              1   Digipeat UI frames
              2   Digipeat non-UI frames
              4   Enable RELAY generic digipeating (deprecated).
              8   Enable TRACE generic digipeating (deprecated).
             16   Enable WIDE generic digipeating (deprecated).
             32   Allow APRS 3rd party digi via L4.
             64   Allow digipeating to Internet (IGate).
            128   Allow digipeating from Internet (IGate).
            256   Enable UITRACE digipeating (e.g. WIDEn-n)
            512   Enable UIFLOOD digipeating (e.g. GBRn-n)

        Example: DIGIFLAG=5 ; all UI + RELAY generic.

        See APRS digipeating.... 

DIGIPORT
        Specifies the port digipeated frames are transmitted onto.
        Default is 0, i.e. the current port.

        Example: DIGIPORT=3 ; Digipeat onto port 3 

DYNDNS
        Enable / disable Dynamic DNS update client. 

ENDPORT *
        Marks the end of the PORT definition block. Subsequent
        keywords are interpreted as GLOBAL.

EXCLUDE
        EXCLUDE specifies a list of one or more callsigns from whom
        AX25 L2 frames are ignored. It would typically be used on a
        user-access port to prevent connections from trouble-makers
        and pirates.  Separate callsigns with commas, and don't
        include any spaces.

        Example: EXCLUDE=NOCALL,P1RAT ; Ignore these users

FEC
        Enable / disable Forward Error Correction.  In order to make
        use of FEC, the port needs to be using a KISS TNC with the
        CRC check disabled (PASSALL ON), or an SCC or YAM card.  The
        default is 0, i.e. disabled.
 
FRACK
        AX25 "T1" timer, i.e. frame acknowledgement time, in
        milliseconds. Default is 7000.

        After sending an AX25 packet, this is the amount of time
        XRouter waits for an "ack" before considering the packet to
        be lost.

        The T1 timer starts when the link layer dispatches the packet
        to the MAC (Media Access Control) layer, so you must allow at
        least enough time for (MAXFRAME * PACLEN) packets to be sent,
        plus an ack packet to be received, plus the other end's
        RESPTIME, plus both end's TXDELAYs, plus a generous allowance
        for channel congestion.

        A frack no less than 7000 millisecs is recommended for
        average 1200 baud links. Setting this figure too low is
        antisocial, achieves nothing, and could result in the link
        retrying out.

        However, on fast, wired (e.g. AXUDP) links, 7 seconds is
        excessive, and a figure like 2000 (2 secs) should be used.

        Example: FRACK=7000 ; 7 seconds

FREQUENCY
        Radio frequency in Hz. Default is 0. If the port is a radio
        port, this value is reported to the node mapping server, if
        such reporting is enabled.

        For non-RF ports (e.g. AXUDP) where this directive has no
        meaning and is ignored.

        Example: FREQUENCY=144925000       ; 144.925 MHz

FULLDUP
        Allow simultaneous TX/RX (SCC only). If you set FULLDUP=1,
        XRouter transmits whenever it needs to, without waiting for
        the other end to stop.

        Used only by hardware which is capable of simultaneous
        transmission and reception, such as full duplex radio or
        wire links. Default is 0 (simplex / half duplex).

        Example: FULLDUP=1   ; Full duplex 

ID *
        Mandatory text to identify port on "PORTS" display. May
        contain spaces. Please make it informative.

        Example: ID=144.825 MHz 9k6 TCP/IP users 

IDPATH
        Specifies the destination and digipeater path for ID beacons.

        The default AX25 destination and path is "ID" with no
        digipeaters. You may wish to modify this, for example on
        APRS ports, to digipeat your beacon.

        Example: IDPATH=APRS,RELAY,WIDE 

IDTEXT
        Optional ID text to use, instead of global IDTEXT, on this
        port only (e.g. for APRS ports). Only one line of text (248
        characters max.) may be specified.

        Example: IDTEXT=!5224.00N/00215.00W# (Kidder)

INITSTR
        Modem initialisation string (MODEM ports only). This is a
        string of characters sent to the modem when Xrouter is
        started.

        Example: INITSTR=ATM0

INTERFACENUM *
        Interface number this port is bound (attached) to. This
        directive is mandatory.
 
INTERLOCK
        Used only by SCC cards, because KISS TNC's make their own
        decisions about when to transmit, and XRouter has no control
        over that process.

        If a non-zero INTERLOCK value is specified, no two ports with
        the same value will transmit at the same time. Default=0.

        Example: INTERLOCK=4

IPADDRESS
        Port override for global IP address. If this is specified,
        it is used instead of the global IP address for all TCP/IP
        operations on this port.

        Example: IPADDRESS=44.131.91.5

IPLINK
        IP address or hostname of AXIP or AXUDP link partner (AXIP
        and AXUDP ports only).

        If the partner has a static IP address, it is more efficient
        to use the IP address here, otherwise it is necessary to use
        the hostname.

        Examples:

            IPLINK=62.51.67.21
            IPLINK=gb7pzt.dyndns.org

MAXFRAME
        Specifies the maximum number of frames XRouter will send to
        an AX25 partner before it must wait for an ack. The normal
        range is between 1 and 7, although maxframes of up to 127
        are allowed on modulo-128 links. The default value of
        MAXFRAME is 3.

        If you set a value between 8 and 63, XRouter attempts to use
        Modulo-128 (Extended AX25) on outgoing links. If the link
        partner is not capable of Modulo-128, the link will fall-back
        to normal AX25.

        If the port PACLEN is set to 0, XRouter dynamicallys adapts
        MAXFRAME (and PACLEN) to the link conditions, to maximise
        throughput.

        Example: MAXFRAME=4

MAXHOPS
        Specifies the maximum accepted hop count for new nodes table
        entries received via INP3 unicasts from neighbours on this
        port. Node information with hop counts that exceed this
        figure are not accepted into the nodes table. This parameter
        has no effect on data received via conventional NetRom nodes
        broadcasts.

        MAXHOPS would typically be used to limit the "hop horizon"
        to a smaller value than the default horizon, which is 30.
        Like MAXTT, it can be used to limit the number of node
        entries that are accepted via a particular port or neighbour.

        It can be overridden for individual routes using by
        "locking-in" the route at the end of XROUTER.CFG, or by a
        ROUTE ADD command in the XRNODES file or at the command
        prompt. Defaults to global MAXHOPS.

MAXTT
        Specifies the maximum accepted "trip time" (transit time)
        for new nodes table entries received via INP3 unicasts from
        neighbours on this port.

        Node information with trip times that exceed this figure are
        not accepted into the nodes table. This parameter has no
        effect on data received via conventional NetRom nodes
        broadcasts.

        MAXTT would typically be used to limit the "trip time
        horizon" to a smaller value than the default horizon, which
        is 60000 (600 seconds). Like MAXHOPS, it can be used to limit
        the number of node entries that are accepted via a particular
        port or neighbour.

        It can be overridden for individual routes using by "locking
        in" the route at the end of XROUTER.CFG, or by a ROUTE ADD
        command in the XRNODES file or at the command prompt.
        Defaults to global MAXTT.
 
MHEARD
        Enable/disable the MHEARD function on this port. The number
        specifies how many callsigns to maintain in the list. Set to
        0 to disable MHEARD. Default is 15 calls.

        Example: MHEARD=10 ; Mheard enabled, 10 calls 

MHFLAGS
        Controls which callsigns are recorded in the MHeard list,
        and defaults to 255 (record everything). The argument is the
        sum of the required options from this list:

                1    Show directly heard stations
                2    Show directly heard digipeaters
                4    Show digipeated stations

        Example: MHFLAGS=1 ; show directly heard stations only

MINQUAL
        Minimum Net/rom quality to add to node table for nodes
        received via this port. Defaults to global MINQUAL.

        Within nodes broadcasts received on that port, any node
        whose quality (after derating by port QUALITY) is less than
        the minqual will not be accepted into the nodes table.

        If specified, this overrides the global minqual, and can be
        used to exclude unreachable and marginal nodes.

        Example: MINQUAL=100 ; No nodes less than quality 100

MINTXQUAL
        Minimum NetRom node quality to include in nodes broadcasts
        on this port. Range 0 to 255, Default is 0. This is used to
        limit the size of nodes broadcasts on ports which are low
        bandwidth, low quality, or where the neighbours have limited
        nodes table capacity.

        Example: MINTXQUAL=100 ; Don't broadcast nodes with qual <100 

NETMASK
        Subnet mask used with IPADDRESS to specify which IP addresses
        are on the same network segment, and can be reached directly.
        For more information see the NETMASK command page. 

NODESINTERVAL
        Interval, in minutes, between NetRom nodes broadcasts on
        this port only. Defaults to global NODESINTERVAL.

        Whilst the Netrom network usually works on a 60 minute
        broadcast cycle, some types of software insist on a much
        smaller broadcast interval.

        It would be harmful to the established network if sysops
        tried to accommodate these neighbours by setting the global
        NODESINTERVAL to a smaller value, but using this keyword on
        a per-port basis you can keep these neighbours happy without
        disrupting the rest of the Netrom network.

        If you set NODESINTERVAL=0, XRouter ignores received nodes
        broadcasts on this port, but will allow L3/L4 activity if
        QUALITY is non-zero.

        Example: NODESINTERVAL=10 ; 10 minues between broadcasts

PACLEN
        Specifies the maximum length of the information-bearing
        portion of ax25 packets transmitted on this port only. If
        not specified, it defaults to the global PACLEN.

        All frames originating at XRouter use the global or port
        paclens specified, but Netrom frames originating at other
        systems can not be fragmented, so we have no control over
        them, and they may be larger than our paclen.

        If the port PACLEN is set to 0, Xrouter dynamicallys adapts
        PACLEN (and MAXFRAME) to the link conditions, to maximise
        throughput.

        Example: PACLEN=160 ; Allow 160 byte packets on this port

PERSIST
        PERSIST is the AX25 "Probability to transmit" in a given
        time slot (see SLOTTIME), used to minimise media contention.

        Persist should be set to (255 / (no. of users on channel)),
        e.g. for a channel with an average of 10 users on at any one
        time you would set Persist to 25. Default is 64.
 
PIPE
        Creates a "frame pipe" to another port. This allows frames
        received (and optionally sent) on this port to be copied to
        another port, e.g. to allow a PMS on one port to see the
        traffic on another port.

        Unless the "bi-directional" option (see below) is specified,
        pipes are one way. In order to have two way traffic using a
        uni-directional pipe, you must set up a reverse pipe on the
        opposite port.

        You may pipe several ports to a single destination port, but
        you can only have one *outgoing* pipe from any port.

        Pipes are capable of generating an immense amount of traffic,
        so use them with care - your target port MUST be capable of
        handling the traffic load.

        By default, pipes are not selective, i.e. they pass traffic
        from any source callsign to any destination callsign (with
        the exception of Budlisted callsigns). On a busy channel,
        this could result in lots of unnecessary traffic being piped.

        Pipes can be made "selective", by adding a comma-delimited
        callsign list, e.g. "PIPE=4 GB7PZT,KDRBBS". This reduces the
        loading on the target port, by piping only the frames with
        the specified calls in the destination field.

        Pipes can also be made selective in terms of the types of
        traffic they pipe (AX25, NetRom etc). This is controlled by
        PIPEFLAG (see below).

        Pipes can be made "bi-directional" by adding 512 to the
        PIPEFLAG value (see below: suggested value = 515). If a
        frame is piped on a bi-directional pipe, the source call is
        remembered so responses can be piped back to the sender.
        Thus a reverse pipe is not needed.

        Bi-directional pipes are useful where a BBS uses XRouter as
        a "front-end" router - simply set up bi-directional selective
        pipes from each user port to the BBS port, and set up the
        BCAST option so that the UI mail headers are broadcast on
        each user port. The BBS then allows direct connects and will
        respond to resync requests.

        To disable piping, set PIPE=0 or just omit the command.

        Example: PIPE=2 ; Pipe frames from this port to port 2 

PIPEFLAG
        PIPEFLAG is only used when piping is active, and controls
        which frames are piped. The default is 3. The argument is
        the sum of the required options as follows:

            1    - UI frames *not* addressed to nodecall/alias.
            2    - Non-UI frames *not* addressed to nodecall/alias.
            4    - UI frames addressed to nodecall/alias.
            8    - Non-UI frames addressed to nodecall/alias.
            16   - UI frames transmitted by XRouter.
            32   - Non-UI frames transmitted by XRouter.
            64   - Allow budlisted users to be piped.
            128  - Netrom frames
            256  - IP / ARP frames
            512  - Bi-directional piping

        Example: PIPEFLAG=5 ; Pipe received UI frames only 

PMSALIAS
        Port override for global PMSALIAS

PMSCALL
        Port override for global PMSCALL

PORTALIAS
        Specifies an AX25 alias for this port, to be used in addition
        to the NODEALIAS.

        Example: PORTALIAS=KDRMIN 

PORTALIAS2
        Secondary alias for digipeating only. This callsign does not
        accept connections. 

PORTCALL
        Specifies an AX25 callsign to use on this port, in addition
        to the NODECALL.

        Example: PORTCALL=G8PZT-1

PROXY
        Remote NetRom systems to whom we will tunnel AX25 L2 frames.
        (See PROXIES page for full explanation)

        Example: PROXY=GB7PZT,GB7BBS

QUALITY
        Default quality for nodes whose broadcasts are received on
        this port (default=10). Setting this to 0 disables all
        NetRom L3/4 activity on this port.

        Example: QUALITY=30

RESPTIME
        AX25 "T2" (delayed ack) timer in milliseconds, i.e. the time
        to wait after receiving a frame, before sending an ack. This
        allows multi-frame transmissions to be acknowledged with a
        single ack, increasing link efficiency.

        Resptime should be long enough for a link partner to transmit
        a full-sized information frame, i.e. approximately
        ((their_paclen * 10000) / RFbauds) millisecs, otherwise you
        will send unnecessary ack frames.

        Too high a value will cause the link to be too "relaxed",
        whereas too low a value will cause too many acks. Both
        extremes reduce the link efficiency.

        1500 (default) is OK for 1200 bauds with paclen=120, but
        2200 would be more appropriate if their paclen was 256. At
        9600 baud, or on AXUDP links, 200 millisecs is probably
        adequate.

        Example: RESPTIME=2000 ; 2 seconds

RETRIES
        AX25 maximum consecutive connect / disconnect / resend
        attempts (default = 10).

        There is little point in setting retries more than 10, other
        than for test purposes. If you need so many retries it's a
        useless link and you're just wasting everyone else's airtime.
        The higher you set this value, the longer users will have to
        wait to get a "failure with" report for a non-contactable
        destination.

        Example: RETRIES=5

RFBAUDS
        RF baud rate (default = 1200).

        This parameter is used with "real" tnc's and YAM modems
        attached via RS232, because the RF baud rate is usually
        different to the RS232 baud rate. It simply helps XRouter
        make timing decisions (such as nodes broadcast inter-packet
        timing) and report certain stats correctly.

        Example: RFBAUDS=2400
 
SESSLIMIT
        Sesslimit specifies the maximum simultaneous connects each
        user is allowed on this port. Default is 255. This would
        typically be used to "choke" users who hog all the bandwidth
        on a port with too many connections.

        Example: SESSLIMIT=5
 
SLOTTIME
        CSMA interval timer (millisecs), used with PERSIST to make
        channel access decisions (default=100).

        If the channel is clear, the TNC (or SCC/YAM card) generates
        a random number which is compared with the PERSIST value. If
        it is less than PERSIST, the TNC waits for the SLOTTIME
        interval, then repeat the action, otherwise it transmits
        immediately.

        This improves throughput by ensuring that everyone doesn't
        transmit as soon as the channel is clear, which would cause
        collisions and retries.

        Example: SLOTTIME=100 ; 100 millisecs per slot

SOFTDCD
        Softdcd is used only by SCC cards and defaults to 0.

        If SOFTDCD=1 the real dcd will be ignored, and the SCC
        driver uses the presence of HDLC data as a DCD indication.

        Using SOFTDCD=1 with an open squelch generates a *huge*
        interrupt loading, which may cause degradation of
        performance, depending on the PC type, so it is not
        recommended.

        Example: SOFTDCD=0

SYSOP
        If you set SYSOP=1, all users who connect on this port get
        full sysop status without needing to answer a password
        challenge. This is intended ONLY FOR USE ON SECURE LINKS,
        such as RS232 or Ethernet, and the default is zero.
 
TXDELAY
        Transmit keyup delay in milliseconds (default=300).

        After keying the transmitter, the TNC (or SCC / YAM card)
        waits for this interval before sending HDLC data. This allows
        the TX to stabilise and the partner's squelch to open.

        Example: TXDELAY=500   ; Synthesiser is slow to lock

TXPORT
        Port to transmit on (default = 0 = this port).

        You would typically use this when several ports share a
        single transmitter, with separate receivers.

        Example: TXPORT=5 ; Transmit on port 5

TXTAIL
        TX turn-off delay in milliseconds (default = 100).

        This is the interval, after sending a frame, for which the
        transmitter remains active. It is intended to allow CRC and
        closing flags to be sent. It has no meaning on non-radio
        ports.

        Due to PC timing inaccuracies, you should set this no lower
        than 100 for SCC cards!

        Example: TXTAIL=100
 
UDPLOCAL
        The UDP port number for the local end of an AXUDP link. Used
        only by AXUDP ports. Default is 93. This number must match
        the link partner's UDPREMOTE, i.e. the destination service
        number in the frames from him to you.

        It is perfectly valid for all your ports to use the same
        UDPLOCAL. This reduces the number of "holes" (port forwards)
        you need to make in your firewall. The *only* reason ever to
        change UDPLOCAL from the default is when you have more than
        one AXUDP node sharing the same public IP address. Your link
        partners have no right to dictate this value!

        Example: UDPLOCAL=7388
 
UDPREMOTE
        The UDP destination number in the AXUDP frames from you to
        your link partner. It must match the link partner's UDPLOCAL,
        otherwise the link will not function.

        If not specified, UDPREMOTE defaults to 93. It is only used
        on AXUDP ports.

        You have no right to dictate this value to your link partner.
        It is THEIR choice only (see UDPLOCAL).

        Example: UDPREMOTE=10093

UNPROTO
        Destination callsign and optional digipeater string used for
        unproto broadcasts from applications on this port. Separate
        the callsigns with commas.

        Example: UNPROTO=CQ,G6YAK

USERS
        Maximum no. of simultaneous users on this port. Default is
        255 which means "no limit".

        Example: USERS=9 

VALIDCALLS
        Validcalls allows AX25 frames only from the specified
        callsigns (opposite of EXCLUDE), and is typically used to
        prevent users from connecting to link-only ports. Callsigns
        must be separated by commas, with no spaces.

        Example: VALIDCALLS=G6YAK,G6AMU ; Accept only these users 

SEE ALSO
        PORTS(6)       -- PORTs in XRouter.
        XROUTER.CFG(8) -- Main Configuration File.

PORTSMORE(6)               END OF DOCUMENT

