PPP(9)                  XROUTER REFERENCE MANUAL            17/10/2023

NAME
        PPP -- Point to Point Protocol.

DESCRIPTION
        Point to Point Protocol (PPP) is a protocol suite intended for
        use over simple links which transport packets between two
        peers, such as an RS232 link (or pair of virtual COM ports).

        Unlike SLIP, it includes facilities for link control (e.g.
        management of a dial up link), user authentication,
        negotiation of IP addresses, and the multiplexing of several
        protocols across a common link.

        PPP is designed to be self configuring.  Most of the options
        have standard default values, and peers negotiate anything
        which differs from the default.

        XRouter currently implements the most common PPP
        sub-protocols:

              - Link Control Protocol (LCP)
              - Password Authentication Protocol (PAP)
              - IP Control Protocol (IPCP)

        Most sysops will have no need to remember these protocol names
        and acronyms.  However, for those who wish to experiment, each
        protocol has its own set of commands.

        PPP has largely replaced SLIP for dial-up Internet access, and
        the interconnection of peers via RS232.

        If you want to know more about the internal workings of PPP,
        it is specified in RFC1661.


        Configuring XRouter for PPP
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~

        There are three ways in which PPP may be used:

              - RS232 (and virtual COM port) links.
              - Dial-in.
              - Dial-out.

        The first case requires an INTERFACE to be configured to use
        PPP, but the other two cases temporarily establish a PPP link
        on a MODEM interface.  Each case is described in more detail
        below:


        Using PPP on Wire / Virtual COM Links
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        In XROUTER.CFG, define an interface with TYPE=ASYNC and
        PROTOCOL=PPP.  For example:

           INTERFACE=1
              TYPE=ASYNC
              COM=1                   ; 1-4 or specify INTNUM/IOADDR
              SPEED=19200             ; Adjust as necessary
              PROTOCOL=PPP
              MTU=1600
           ENDINTERFACE


        Then "bind" a port to that interface thus:

           PORT=1
              ID=PPP link to Win98    ; Text to identify port
              INTERFACENUM=1          ; Bind to PPP interface
              IPADDRESS=192.168.0.4   ; Optional (see below)
           ENDPORT


        The use of IPADDRESS is optional.  If the keyword is omitted,
        XRouter's "global" IP address will be used on that port.  If
        the address is specified as 0.0.0.0, it signifies that a
        "dynamic" IP address should be obtained from the peer,
        otherwise the specified address will be used.

        The port is now ready for PPP using the standard PPP defaults,
        but if it requires any further configuration you may include
        the relevant PPP configuration commands in the file
        BOOTCMDS.SYS, which is read by XRouter at boot-up, after it
        has finished reading XROUTER.CFG.


        Using PPP on Dial-in links
        ~~~~~~~~~~~~~~~~~~~~~~~~~~

        The INTERFACE and PORT should be configured for PROTOCOL=MODEM
        as described in the manual section "PSTN Modem Support".

        When a logged-in caller issues the command XLINK PPP, XRouter
        automatically re-configures the port to support PPP.  It then
        looks for the file "PPPHOST.n", where n is the port number,
        and if found, the PPP configuration commands within the file
        are executed.  The file may optionally contain NAT
        configuration commands if required. The PPPHOST file is
        optional.  If not present, PPP will be initialised to the
        standard defaults.

        When the hardware link disconnects (e.g. user says goodbye or
        hangs up, link times out, or sysop kills it), the port is
        automatically re-configured back to its original MODEM
        protocol.


        Using PPP on Dial-out links
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~

        The INTERFACE and PORT should be configured for PROTOCOL=MODEM
        as described in the manual section "PSTN Modem Support".  The
        local IP address follows the same rules as the wire-link case
        above, but may be overridden temporarily by IPCP commands.

        The dialler script (see DUN section) must contain the command
        "MODE PPP" plus any required PPP configuration commands.  Here
        is an extract from a typical connection script:

          ; Link will use PPP
          mode ppp
          ;
          ; Configure my authentication username and password
          ppp pap user gb7pzt bsfjflavs
          ;
          ; Set inactivity timeout to 2 minutes
          ppp idle 120
          ;
          ; Enable ppp state logging
          ppp log 1
          ;
          ; Set my (static) IP address for the duration of this call
          ppp ipcp local address 194.123.110.4
          ;
          ; Now dial the host
          send ATDT07979654234
          ;
          etc...

        The PPP configuration will persist until the call terminates,
        then the port will revert back to MODEM protocol to await the
        next incoming or outgoing call.


        PPP Configuration Commands
        ~~~~~~~~~~~~~~~~~~~~~~~~~~

        All PPP configuration commands start with "PPP", and are
        described in the sysop command reference section.   When used
        from the command line, or with a BOOTCMDS.SYS file, the first
        argument must be a port number.  However, PPP commands used
        within PPPHOST and dialler scripts *do not* include a port
        number, because XRouter knows which port is executing the
        script.

        e.g. at the command line: PPP 3 IDLE 300
             in a dialler script: PPP IDLE 300


        IP Routing with PPP
        ~~~~~~~~~~~~~~~~~~~

        When a PPP link opens, a route to the peer is automatically
        added to XRouter's IP routing table.  If the peer indicates
        that it knows the addresses of a primary and secondary DNS,
        those are added to XRouter's DNS list.


        PPP Logging
        ~~~~~~~~~~~

        PPP system activity can be recorded in file PPPLOG.TXT for
        diagnostic purposes.  The amount of detail is controlled by
        the number specified in the "PPP <port> LOG n" command as
        follows:

              0       No logging
              1       PPP start / stop / timeout events
              2       As 1, plus layer up / down events
              3       As 2, plus layer start / stop events
              4       as 3, plus option accept / reject events
              5       as 4, plus hexdump of configuration packets

        You are advised against using the higher levels other than on
        a temporary basis because they can create very large logfiles.

        If logging is in use, you should regularly remove the logfiles
        to prevent them growing too large.

SEE ALSO
        BOOTCMDS.SYS(8) -- Bootup Configuration Commands File.
        DIAL(1)         -- Dial a PSTN connection.
        DUN(1)          -- Dial Up Networking Configuration Commands.
        DUN(9)          -- Dial-Up Networking.
        PPP(1)          -- PPP Configuration Commands.
        PPPHOST.n(8)    -- PPP Configuration File(s)
        PSTN(9)         -- PSTN Modem Support.
        SCRIPT(9)       -- Dialer Scripts.
        XLINK(1)        -- Establish a Temporary SLIP / PPP Interlink.
        XROUTER.CFG(8)  -- Main Configuration File.

PPP(9)                      END OF DOCUMENT
