PPP(1)                  XROUTER REFERENCE MANUAL            18/10/2023

COMMAND
        PPP -- Point to Point Protocol Configuration commands.

SYNOPSIS
        PPP <port> IDLE [secs]
        PPP <port> IPCP <LOCAL | REMOTE> <ADDRESS | DNS> [ipaddr]
        PPP <port> LCP <LOCAL | REMOTE> AUTH [PAP]
        PPP <port> LCP <LOCAL | REMOTE> DEFAULT
        PPP <port> LCP <LOCAL | REMOTE> MRU [mru]
        PPP <port> LOG [0-255]
        PPP <port> PAP <USER> [username password]

AVAILABILITY
        Sysop-only.

DESCRIPTION
        Point to Point Protocol (PPP) is a protocol suite intended
        for use over simple links which transport packets between two 
        peers, such as an RS232 link.  The PPP commands are used to 
        configure the system.

OPTIONS
        The IDLE subcommand is used to display or set the PPP link 
        inactivity timer, which disconnects the link after a period of 
        inactivity.  The argument is in seconds.

        The IPCP subcommands control the IPCP (IP Control Protocol) 
        parameters for each end of the link.  ADDRESS specifies the
        IP addresses used for the link, and DNS specifies the IP 
        addresses of the Domain Name Server.  

        The LCP subcommands control the LCP (Link Control Protocol) 
        parameters for each end of the link.  AUTH specifies the 
        authentication protocol (if any) which the link will use.
        The only authentication protocol currently supported is PAP.

        The MRU command specifies the Maximum Receive Unit, i.e. the 
        largest datagram the host is prepared to accept.  The limits 
        are 128 and 4096. DEFAULT restores the default LCP parameters 
        which all hosts understand. 

        The LOG subcommand displays or sets the PPP logging level, 
        which controls how much diagnostic detail is recorded in the 
        PPLOG.TXT file.  The argument is as follows:

                0       No logging
                1       PPP start/stop/timeout events
                2       As 1, plus layer up/down events
                3       As 2, plus layer start/stop events
                4       as 3, plus option accept/reject events
                5       as 4, plus hexdump of configuration packets

        The PAP subcommand displays or sets PAP (Password 
        Authentication Protocol) parameters.  At present the only 
        parameter is USER, which specifies the username and password 
        for PAP login.

EXAMPLES
        PPP 1 IDLE 300
        PPP 1 IPCP LOCAL ADDRESS 62.31.45.67
        PPP 3 LCP LOCAL AUTH PAP
        PPP 3 LCP LOCAL DEFAULT
        PPP 3 LCP LOCAL MRU 1500
        PPP 3 LOG 3
        PPP 1 PAP USER g8pzt zedfrgc

NOTES
        When used from the command line, or with a BOOTCMDS.SYS file, 
        the first argument must be a port number.  However, PPP 
        commands used within PPPHOST and dialler scripts *do not* 
        include a port number, because XRouter knows which port is 
        executing the script.

        e.g. at the command line: PPP 3 IDLE 300
             in a dialler script: PPP IDLE 300

        You are advised against using the higher PPP LOG levels other 
        than on a temporary basis because they can create very large 
        logfiles.

SEE ALSO
        DUN(9)    -- Dial-up Networking
        PPP(9)    -- Point to Point Protocol.
        SCRIPT(9) -- Dialler script commands

PPP(1)                      END OF DOCUMENT
