PROTOCOL(7)             XROUTER REFERENCE MANUAL            24/10/2023

NAME
        PROTOCOL -- Protocol Used on INTERFACE.

SYNPOSIS
        PROTOCOL=<protocol>

DESCRIPTION
        PROTOCOL is a configuration directive used within INTERFACE
        definition blocks in XROUTER.CFG, to specify the protocol to
        use on the interface.

        It is mandatory in most types of INTERFACE, but not required
        in other types, e.g. TYPE=AXIP, AXUDP etc.

        <protocol> must be one of the options detailed below.

OPTIONS
        ASCII   - Raw ASCII.
                  This is a plain ASCII *uplink* to XRouter's
                  command interpreter from a real "dumb terminal",
                  or a "terminal emulator" such as Hyperterm,
                  Procomm, PuTTY, Telink etc. via ASYNC interface.
                  May also be used via TCP or UDP interface types.

        AX25    - Pure AX25, with no CRC or HDLC framing.
                  Used for devices which provide their own CRC and
                  HDLC framing, such as AGW, SCC cards, Baycom & YAM
                  modems. Can also be used via "block mode"
                  interfaces which need no CRC or HDLC framing, such
                  as types LOOPBACK, TCP and UDP. 

        AXIP    - AX25 (with CRC) over IP.
                  This is implicit for interface type AXIP, but does
                  not cause an error if specified. Not for use with
                  any other interface type.  See AXIP(9) for
                  more information.

        AXTCP   - AX25 (with CRC) over TCP/IP
                  This is implicit for interface type AXTCP, but
                  does not cause an error if specified. Not for use
                  with any other interface type.  See AXTCP(9) for
                  more information.

        AXUDP   - AX25 (with CRC) over UDP/IP.
                  This is implicit for interface type AXUDP, but
                  does not cause an error if specified. Not for use
                  with any other interface type. See AXUDP(9) for
                  more information.

        DEDHOST - WA8DED Host Mode emulation.
                  Used with ASYNC interface to support applications
                  such as F6FBB BBS via real RS232 or pseudo-TTY
                  pairs.  See DEDHOST(9) for more information.

        ETHER   - Ethernet protocol.
                  Usually used with interface type EXTERNAL, but may
                  also be used via LOOPBACK, TCP and UDP interfaces.

        HDLC    - High-level Data Link Control protocol.
                  This is not proper HDLC! It is AX25 with CRC, but
                  without the HDLC flags and bit stuffing. For use
                  with TCP, UDP and LOOPBACK interface types.

        IP      - Raw Internet Protocol (IPv4).
                  Used primarily for TUN interfaces, but may also be
                  used on TCP, UDP and LOOPBACK interfaces.

        KISS     - AX25 within KISS framing.
                   Used via ASYNC interfaces for driving KISS TNCs,
                   via TCP interface for soundcard packet drivers
                   such as UZ7HO, Soundmodem, Direwolf etc.
.
        MODEM    - Hayes compatible PSTN modem.
                   This is used only on ASYNC interfaces.

        NETROM   - NetRom "backend" serial protocol.
                   This is an "inter-node" protocol originally
                   intended for linking NetRom TNC's (i.e. real
                   TNCs running NET/ROM or TheNet node EPROM's) via
                   their serial ports. Used with ASYNC interface
                   type, but may also be used via LOOPBACK, TCP and
                   UDP interfaces. The latter two 

        NONE     - No protocol.
                   This is a dummy protocol for use with LOOPBACK.

        PPP      - Point to Point Protocol.
                   Used to transport IP over serial links such as
                   RS232, dial-up connections etc. Used mainly with
                   ASYNC interfaces, but can also be used on TCP,
                   UDP and LOOPBACK. See PPP(9) for more info.

        SLIP     - Serial Line Internet Protocol.
                   This is IPv4 in a very simple encapsulation, for
                   use on ASYNC interfaces, but can also be used on
                   TCP, UDP and LOOPBACK.  See SLIP(9) for more.

        TNC      - TNC command line protocol.
                   This is a plain ASCII *downlink* from XRouter to
                   the command interpreter of a real TNC, or that of
                   an application which accepts TNC-style commands,
                   such as VARA. Used with ASYNC, TCP or UDP
                   interfaces.

        TNC2     - TNC2 emulator.
                   This is an 8-bit ASCII *uplink* from an external
                   device or program to XRouter's TNC2 emulator,
                   where XRouter looks like a "real" multi-port TNC
                   as far as the external device is concerned.
                   Usually used with ASYNC interface, but may also
                   be used with interface types TCP and UDP.
                   See TNC2(9) for more information.

NOTE
        The LOOPBACK interface is completely internal to XRouter,
        and is intended only for test purposes. The use of any of
        the above protocols via LOOPBACK is completely pointless!

SEE ALSO
        IFACES(6)      -- Interfaces in XRouter.
        AXIP(9)        -- AX25 over IP Tunneling Protocol.
        AXTCP(9)       -- AX25 over TCPP Tunneling Protocol.
        AXUDP(9)       -- AX25 over UDP Tunneling Protocol.
        DEDHOST(9)     -- WA8DED Hostmode Emulation.
        PPP(9)         -- Point to Point Protocol.
        PSTN(9)        -- PSTN Modem Support.
        SLIP(9)        -- Serial Line Internet Protocol.
        TNC2(9)        -- TNC2 Emulator.
        XROUTER.CFG(8) -- Main Configuration File.

PROTOCOL(7)                  END OF DOCUMENT
