;*************************** Max Width *******************************
PROXIES(9)             XROUTER REFERENCE MANUAL              26/9/2023

NAME
        PROXIES -- Proxy Connections.

DESCRIPTION
        In this context, "proxies" are cross-protocol bridging
        mechanisms which allow systems using one protocol to be
        accessed using another protocol. They can also be used
        to give "hidden" systems a network presence.
 

        AX25 -> NETROM PROXY
        ====================

        This facility allows AX25 level 2 callers to connect
        "directly" to remote NetRom target callsigns, without
        needing to connect first to XRouter then issue a downlink
        connect request. In effect, it gives the NetRom target
        system a local AX25 presence.

          .------.          .-------.            .--------.
          | user |-- Ax25 --| proxy |-- NetRom --| target |
          '------'   link   '-------'    link    '--------'
           (g5ur)            (g8pzt)              (gb7bbs)

            
          .------.      Ax25 link        .-------.
          | G5UR |-- G5UR -> <- GB7BBS --| G8PZT |
          '------'                       '-------'
            (Proxy at G8PZT masquerades as GB7BBS)


        This facility is primarily for use in situations where
        a BBS or PMS is wire-linked to a "front-end" router,
        thus allowing the BBS callsign to be directly
        connectible on any port for which the proxy call is
        defined.  You may find other uses....

        A bi-directional selective frame pipe would provide a
        similar effect, but only for systems directly connected
        to XRouter, whereas PROXY allows the target system to be
        located several hops away.  Pipes can handle UI frames,
        whereas PROXY is for connected-mode operations only.

        Here's how it would be used on a typical set-up, which
        has two machines (or a virtual COM port linking two
        systems on the same machine). Only XRouter is connected to
        the radios, the BBS being KISS-linked to XRouter's port 7.

         -----------  (1)
        | Radio/TNC | ---.
         -----------     |
                         |    .---------.            .---------.
         -----------  (2)|    |  NODE   | (7) KISS   | GB7PZT  |
        | Radio/TNC |----|----|         |------------|         |
         -----------     |    |(XRouter)|  (rs232)   |  (BBS)  |
                         |    `---------'            `---------'
         -----------  (3)|
        | Radio/TNC |----|
         -----------     |
                         V
                        etc.

        Without PROXY, level 2 users would have to connect to
        XRouter, then issue the command "C GB7PZT",or "BBS" to
        connect to the BBS.

        With the line "PROXY=GB7PZT" in port 1's definition
        (in XROUTER.CFG), users on port 1's frequency simply
        connect to "GB7PZT" - XRouter intercepts the request and
        answers on behalf of the BBS.  It then connects via
        NetRom to GB7PZT.  In this case, the BBS is running on
        top of BPQ, so it has a NetRom address.

        If the target system (GB7PZT in this case) is not
        reachable via NetRom level 4, the connect request is
        refused.

        If you wish to use this facility, you must add a
        "PROXY=<call1>[,call2,...]" directive to each user PORT
        concerned.  Ports without the directive continue to
        function as normal.  You obviously wouldn't enable it
        on your forwarding ports for example.  You will notice
        that you can have several callsigns on the line, each
        separated by a comma, allowing you to act as a proxy
        for more than one system.

        Warning!  DO NOT enable PROXY on any frequency which
        is shared by the target system or you'll cause horrible
        problems (both the target and the proxy will respond to
        connects at the same time).


        AX25 / NETROM -> TCP PROXY
        ==========================

        This is an extension of the PROXY concept, allowing a
        remote TCP/IP-only system to have NetRom and AX25
        connectivity.

          .------.          .-------.            .--------.
          | user |-- Ax25 --| proxy |-- TCP/IP --| target |
          '------'   link   '-.-----'    link    '--------'
                              |
          .-------.           |
          | user2 |-- NetRom--'
          | @node |    link
          '-------'

        In the previous example, GB7PZT BBS used G8BPQ node
        "underneath" the BBS to provide NetRom connectivity
        across the KISS link.  With the extended proxy, BPQ can
        be removed altogether and the BBS can be run in pure
        TCP/IP mode.  This saves memory, whilst improving speed
        and reliability.  The BBS no longer has to support
        multiple protocols or interface types, that job being
        delegated to XRouter.

        Instead of having to connect first to XRouter then issue
        the awkward command "Telnet 44.131.91.2", users can
        simply connect "directly" to the BBS callsign (GB7PZT)
        on one of XRouter's radio ports. XRouter converts that
        connection into a TCP/IP connection with the BBS, and
        translates the data back and forth between AX25 and
        TCP/IP.

        Furthermore, the BBS callsign "GB7PZT" can be connected
        to directly from XRouter's command line, and also included
        in nodes broadcasts so it can be reached from a remote
        node.

        This type of proxy is created by putting an extended
        PROXY statement in the GLOBAL section of XROUTER.CFG,
        using the following format:

        PROXY=<call> <alias> <qual> <ipaddr> <tcpport> [passwrd]

        For example:

           PROXY=GB7PZT KDRBBS 150 192.168.0.4 8888 bloggs

        <call>    is the NetRom and AX25 callsign for the
                  proxied system.

        <alias>   is the NetRom / AX25 alias for the proxied
                  system.

        <qual>    is the NetRom "quality" (0 - 255) controlling
                  visibility on the NetRom network.

        <ipaddr>  is the proxied system's IP address.

        <tcpport> is the TCP service port number of the
                  proxied system.

        <passwrd> is an optional password sent to proxied
                  system upon connection. This is used to
                  verify that the TCP connection originates
                  from an approved proxy.

        AX25 and NetRom are pure binary channels, whereas standard
        telnet is not. The proxied system must provide a pure
        binary service port in order to make full use of this
        facility for compressed forwarding etc. G8PZT's "XServ"
        BBS software provides such a facility on TCP port 8888.

        If you are a software author interested in adapting your
        software to work with this proxy, the following information
        will be useful:

        Upon connection to the proxied system XRouter sends one line
        of text ending in <CR><LF>, containing one or more
        space-delimited fields. The first field is the callsign of
        the connectee in the form "G8PZT-7" (ax25) or
        "G6YAK-2@GB7BM" (NetRom).  The second field is a password
        which verifies the proxying system (note this is not the
        user's password).  Thereafter, the link switches to pure
        binary, and in accordance with AX25 practice both systems
        must send line ends as <CR> alone.

        There is no limit to the number of proxies you may
        configure.


        NETROM -> AX25 PROXY
        ====================

        This is similar to the NetRom -> TCP proxy described
        above, but is intended to allow an AX25-only system to
        have a NetRom presence.

          .------.            .-------.          .--------.
          | user |-- NetRom --| proxy |-- AX25 --| target |
          |@node |    link    '-------'   link   '--------'
          '------'               ^
             ^-(Target callsign appears in)
               (nodes tables on these nodes)


        This is enabled by putting an extended PROXY statement
        in the GLOBAL section of XROUTER.CFG, using the
        following format:

           PROXY=<call> <alias> <qual> <ax_call> <portnum>

        For example:

           PROXY=MB7UYL UYLBBS 150 G6KDR-3 7

        <call>    is the NetRom and AX25 callsign for the proxied
                  system.

        <alias>   is the NetRom / AX25 alias for the proxied
                  system.

        <qual>    is the NetRom "quality" (0 - 255) controlling
                  visibility on the NetRom network.

        <ax_call> is the proxied system's AX25 L2 callsign.

        <portnum> is the radio port the proxied system is
                  connected to.

        The above example creates a NetRom node whose callsign
        is "MB7UYL", alias "UYLBBS", with NetRom quality 150.
        Anyone who makes a connection to either of these
        addresses will instead be connected to the AX25 system
        "G6KDR-3", attached to XRouter's port 7.

OPTIONS
       Summary of the syntax for the 3 types of proxy....

       AX25 -> NetRom:
       ~~~~~~~~~~~~~~~
       PROXY=<call1>[,call2[,...]]

       AX25 / NetRom -> TCP:
       ~~~~~~~~~~~~~~~~~~~~
       PROXY=<call> <alias> <qual> <ipaddr> <tcp_port> [passwrd]

       NetRom -> AX25:
       ~~~~~~~~~~~~~~
       PROXY=<call> <alias> <qual> <ax_call> <portnum>
 
CAVEATS
        Be *very* careful when mixing proxies and pipes, or you
        will end up generating lots of FRMR's, and possibly
        crashing the system. These are powerful tools and must
        be used carefully.

        Proxies are intended for use with your own systems only.
        Do not act as a proxy for someone else's system without
        their permission.

        You must *NEVER* set up a proxy to give a NetRom
        presence to a node which already has one!!

        For proxies which include <portnum>, please ensure that
        the port actually exists (sysops often rearrange ports
        rendering the proxies inactive).

SEE ALSO
        PROXY(7)       -- Proxy Connectivity.
        PIPES(9)       -- Frame Pipes.
        XROUTER.CFG(8) -- Main Configuration File

PROXIES(9)                END OF DOCUMENT
