;*************************** Max Width *******************************
PROXY(7)              XROUTER REFERENCE MANUAL               26/9/2023

NAME
        PROXY -- Proxy Connectivity.

SYNOPSIS
        PROXY=<call1>[,call2,...]
        PROXY=<call> <alias> <qual> <ax_call> <portnum>
        PROXY=<call> <alias> <qual> <ipaddr> <tcp_port> [passwrd]

DESCRIPTION
        PROXY is an optional XROUTER.CFG directive that can be used
        both "globally" and within PORT definition blocks.

        It is used to define "proxies", which are AX25 or NetRom
        addresses which provide connectivity for otherwise
        unreachable targets. For example, providing an AX25 callsign
        for a TCP-based BBS. (See PROXIES page for full explanation).

OPTIONS
        If used within a PORT definition block, PROXY defines an
        "AX25-to-NetRom" proxy, giving a NetRom target system a direct
        AX25 presence on the port. The format is:

            PROXY=<netrom1>[,netrom2,...]

            <netrom1> and <netrom1> are the NetRom callsigns of the
            proxied systems.

            Example: PROXY=GB7PZT,GB7BBS

        If used within the "global" section of XROUTER.CFG, there are
        TWO possible forms of the PROXY, as follows:

        The first of these is the "NetRom-to-AX25" proxy, the opposite
        of the above, whereby an AX25-only target is given a NetRom
        and AX25 presence, as if it was a real NetRom node. I.e. it
        appears in XRouter's nodes table and is broadcast to its
        neighbours.

            PROXY=<call> <alias> <qual> <ax_call> <portnum>

            <call> is the NetRom and AX25 callsign
            <alias> is the NetRom and AX25 "alias"
            <qual> is the NetRom "quality" of the node in our table
            <ax_call> is the AX25 callsign of the proxied system
            <portnum> is the PORT where the proxied system resides

            Example: PROXY=MB7UYL UYLBBS 150 G6KDR-3 7

        The second "global" form is the "AX25/NetRom-to-TCP" proxy,
        which gives a TCP-only system both an AX25 and a NetRom
        presence on all ports. It is specified like this:

            PROXY=<call> <alias> <qual> <ipaddr> <tcp_port> [passwrd]

            <call> is the NetRom and AX25 callsign
            <alias> is the NetRom and AX25 "alias"
            <qual> is the NetRom "quality" of the node in our table
            <ipaddr>  is the proxied system's IP address.
            <tcp_port> is the TCP port number of the proxied system.
            <passwrd> is an optional password sent to the proxied
                      system upon connection. The proxied system uses
                      this to verify that the TCP connection
                      originates from an approved proxy.
 
            Example: PROXY=GB7PZT KDRBBS 150 192.168.0.4 8888 bloggs

WARNING
        Proxies are very useful, but very dangerous if you aren't sure
        what you are doing! Proxy-created "forever loops" can kill
        XRouter, or cause interference to other systems. Don't use
        them if you don't need to, and please read the warnings in the
        PROXIES page. If your XRouter crashes, and you have proxies,
        then its a sure sign that you have configured them wrongly!

SEE ALSO
        PROXIES(9)     -- About Proxy Connections.
        PORTS(6)       -- Ports in XRouter.
        XROUTER.CFG(8) -- Main Configuration File.

PROXY(7)                  END OF DOCUMENT
