PSTN(9)                 XROUTER REFERENCE MANUAL            18/10/2023

NAME
        PSTN -- PSTN Modem Support.

DESCRIPTION
        The following text describes a facility which was inherited
        from DOS XRouter, but which probably has no relevance
        nowadays?... 

        XRouter may be connected to one or more Public Switched
        Telephone Network (PTSN) modems, for dial-in and dial-out
        operations.

        Dial-in would, for example, allow users and/or sysops to
        connect to XRouter and operate it using a dumb terminal or a
        standard terminal package such as Telix or Hyperterm.

        Alternatively, after login, the link may be switched into
        SLIP or PPP mode for TCP/IP operations, behaving in exactly
        the same way as a dial-up Internet Service Provider.

        Dial-out allows XRouters to be linked with each other or with
        an Internet service provider, for the purposes of on-demand
        wired routing, or Internet Connection Sharing.

        A single modem may be used for both dial-in and dial-out
        operations on the same port, although not at the same time
        of course!


        Suitable Modem Types
        ~~~~~~~~~~~~~~~~~~~~

        Almost any modem is suitable, providing it can be initialised
        by a single string of characters and can be configured to
        disconnect when DTR is dropped.


        Hardware Configuration
        ~~~~~~~~~~~~~~~~~~~~~~

        External modems should be connected to a serial port using a
        cable with at least 8 connections, namely TXD, RXD, RTS, CTS,
        DTR, DSR, DCD and ground.  The RI (ring indicator) connection
        is not needed.

        Internal modems should be configured to use a spare COM
        number and IRQ.


        Software Configuration
        ~~~~~~~~~~~~~~~~~~~~~~

        Each modem requires an ASYNC interface definition in
        XROUTER.CFG, with COM (or IOADDR & IRQ if non-standard)
        configured for the appropriate serial port or modem card.
        You should use PROTOCOL=MODEM, FLOW=1 and MTU=576.

        To each "modem" interface should be attached a PORT with at
        least INTERFACENUM and ID specified.

        If the modem requires an initialisation string, add the
        directive INITSTR=<initstring>, e.g. to set the modem into
        auto answer mode use "INITSTR=ATS0=1".  If you don't include
        the INITSTR directive, the modem configuration is unaltered.

        If your modem does not, by default, hang up when the RS232
        DTR signal is dropped, you should configure it to do so by
        including "&D2" in the initialisation string, for example:
        "INITSTR=ATM0S0=1&D2".


        Example MODEM Interface and Port Configuration
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        In XROUTER.CFG:

            INTERFACE=5
                TYPE=ASYNC
                COM=3     ; (or /dev/ttyxx for Linux)
                SPEED=57600
                PROTOCOL=MODEM
                FLOW=1
                MTU=576
            ENDINTERFACE

            PORT=2
                ID=PSTN Modem port
                INTERFACENUM=5
                INITSTR=ATS0=1
            ENDPORT


        If you will be allowing incoming calls, you must set up a
        callsign and password entry for each user in USERPASS.SYS.


        Dial-in Operation
        ~~~~~~~~~~~~~~~~~

        If you have configured the modem for auto-answer, PSTN
        callers must successfully complete a callsign and password
        challenge before they are allowed to use the XRouter command
        interface.

        The callsign must be a proper amateur radio callsign, not
        a "username".  If a valid callsign is not given, or if the
        callsign is not found in USERPASS.SYS, or if an incorrect
        password is supplied, the user is immediately disconnected.

        If this sounds unforgiving, it is meant to be!  It will cost
        hackers the price and time delay of a separate phone call
        for each attack.

        If the callsign and password challenge is successfully
        completed, the caller will be allowed full access to the
        command shell, exactly the same as a radio caller.

        XRouter will disconnect the caller after 15 minutes of
        inactivity.  You may initialise the modem to disconnect after
        a shorter interval if necessary.


        The XLINK command
        ~~~~~~~~~~~~~~~~~

        If the caller (e.g. using NOS) wishes to establish a TCP/IP
        link with XRouter, the XLINK command is used to switch the
        ASCII link into SLIP ("XLINK SLIP") or PPP ("XLINK PPP")
        mode.

        XRouter responds with "Entering SLIP mode" or "Entering PPP
        mode", and will thereafter no longer respond to ASCII
        commands.  SLIP or PPP mode may only be terminated by
        disconnection.

        In order to use SLIP or PPP modes, XRouter must have at least
        a global IPADDRESS, and you must set up IP routing to the
        caller's IP address on the modem port.

        You could either allow each caller to use their own IP
        address, and have one routing entry for each caller, or you
        may choose to require all callers on a particular port to use
        the same IP address (since only one may connect at any time)
        and set up a single routing entry.

        For example, you could tell each of your SLIP/PPP callers to
        set their IP address to 192.168.73.88, which is one of the
        "unregistered"  addresses anyone can use.  If your modem is
        on port 2, you would add the following entry to IPROUTE.SYS:

           route add 192.168.73.88/32 * 2 d

        Which means "route datagrams for 192.168.73.88 directly on
        port 2 using datagram mode".

        No ARP entry is necessary for the caller, because SLIP and
        PPP do not use "hardware addresses".


        XLINK PPP mode
        ~~~~~~~~~~~~~~

        XLINK SLIP mode requires no extra configuration, but PPP mode
        optionally uses an extra file to configure the PPP system for
        receive operations on the modem port.  For example, you may
        wish to use one IP address when making outgoing connects and
        a different one when receiving incoming connects.

        The optional file is named "PPPHOST.n" where n is the number
        of the modem port, e.g. "PPPHOST.2".  You may have a separate
        file with a different configuration for each modem port if
        required.  The file should be located in the same directory
        as XRouter itself and may contain any PPP configuration
        command.

        See the description of PPP commands for details of how to
        configure PPP.

        The PPP link inactivity timeout defaults to 5 mins, but can
        be overridden by including the PPP IDLE command in the
        PPPHOST.n file.

SEE ALSO
        DIAL(1)        -- Dial a PSTN Connection
        DUN(1)         -- Dial Up Networking Commands.
        PPP(1)         -- PPP Configuration Commands.
        PPPHOST.n(8)   -- PPP Configuration File(s)
        XLINK(1)       -- The XLINK Command.
        XROUTER.CFG(8) -- Main Configuration File.

PSTN(9)                     END OF DOCUMENT
