QUALADJ(7)              XROUTER REFERENCE MANUAL            18/10/2023

NAME
        QUALADJUST -- NetRom Quality Manipulation.

SYNOPSIS
        This file describes a feature which allows you to reduce
        the NetRom quality of "foreign" nodes on your system, or to
        exclude certain nodes or groups of nodes altogether.

DESCRIPTION
        With ever-increasing connectivity via the Internet, the
        NetRom network is bypassing national and geographical
        boundaries, and this is causing problems.  Because Internet
        qualities are much higher than radio qualities, there are
        far more nodes in the tables.
        
        In some cases there may be a limit to the size of tables,
        and more importantly there is a limit to the number of nodes
        that can be broadcast on a low bandwidth RF channel.

        In addition, with too many nodes in the table the "N"
        commands become useless because the response becomes too
        large for the user to download on a limited bandwidth
        channel.  Even if there is sufficient bandwidth, the
        response may occupy several pages and the user may not be
        able to review anything which has scrolled off the screen.

        Experience has shown that 150 nodes is roughly the maximum
        comfortable table size. But how do you decide *which* 150
        nodes to include?  How do you achieve the balance between
        slow, unreliable, radio-routed nodes and fast, reliable,
        Internet-routed ones?

        Some people advocate setting low route qualities for the
        Internet links, but unless everyone agrees on those
        qualities, this can lead to traffic being routed via slow,
        unreliable links when faster and more direct routes exist!

        And do you want your table full of high quality
        internet-routed foreign nodes, to the exclusion of your
        local RF nodes?  Can your users find the nodes they want,
        amidst the clutter?

        Quality de-rating by callsign can help with this management
        issue.  It allows you to de-rate the NetRom quality of a
        node or group of nodes based on the NetRom callsign,
        instead of the route on which they were received.

        Thus, no matter what relative route qualities you use, you
        can change the relative qualities to favour your local
        nodes, or (more likely) those which share your language.

OPTIONS
        This feature uses the global QUALADJUST directive in
        XROUTER.CFG as follows:

           QUALADJUST <call | "default"> <0-255>

        e.g.    QUALADJUST DEFAULT 120
                QUALADJUST G* 255
                QUALADJUST ZL* 200

        The "default" argument sets the default value which is used
        to de-rate all nodes not matched by any other QUALADJUST
        statement.  The normal NetRom de-rate algorithm is used, so
        255 gives no de-rate and 0 gives full de-rate (i.e. to block
        a callsign or group of callsigns). If there are no
        QUALADJUST statements the default is 255.

LIMITATIONS
        QUALADJUST is applied to neighbour nodes and all nodes
        learned from NetRom broadcasts.  It is NOT applied to nodes
        learned via INP3 because they have no quality to de-rate,
        and is not applied to nodes entered by a NODE ADD command or
        an entry in the XRNODES file.
       
CAVEATS
        This is an experimental feature. Please use it with caution.

SEE ALSO
        AUTOQUAL(9)    -- Automatic Route Quality.
        NODES(1)       -- Display / Modify the Nodes table.
        QUALITY(1)     -- Display / Set default quality for a port.
        XRNODES(8)     -- Routes / Nodes Recovery File.
        XROUTER.CFG(8) -- Main Configuration File.

QUALADJ(7)                END OF DOCUMENT
