;**************************** Max Width ******************************
RADIO(7)              XROUTER REFERENCE MANUAL               21/9/2023

NAME
        RADIO -- Radio control definition block.

SYNOPSIS
        RADIO=n (where n is a number between 1 and 5)

DESCRIPTION
        RADIO is an optional directive used in XROUTER.CFG. If
        present in the "global" section, it begins a "radio control"
        block, which is used, along with the RADIO command, to
        control an attached radio.

        If present within an INTERFACE definition block, RADIO
        specifies which previously defined radio block is associated
        with the interface.

        RADIO definition blocks start with RADIO=n, contain a number
        of other directives, and end with ENDRADIO. They *must* be
        defined BEFORE any INTERFACEs that refer to them.

OPTIONS
        The following directives are accepted within a RADIO block:

        NAME    Specifies a name for this radio, e.g. "HF Rig".
                Maximum 63 characters, spaces allowed.

        TYPE    Radio type: 1=Custom, 2=Icom ICR7000, 3=Icom PCR1000,
                4=Yaesu Ft100, 5=Flex, 6=Hamlib.

                ICR7000 is a receiver which uses Icom CI-V interface.
                PCR1000 is a receiver which uses serial TTY control
                FT100 is a transceiver using Yaesu CAT interface
                FLEX is for Flexradio
                HAMLIB lets XR talk to Hamlib which controls the rig.

                Additional radio types can be added upon request.

        COM     Specifies how XRouter communicates with the rig.
                For most types this is via a TTY, for example
                "COM=/dev/ttyUSB0". But for Hamlib it should specify
                the IP address and port used by Hamlib,
                for example "COM=127.0.0.1:3900".

        BAUDS   Baud rate for the TTY (not needed for Hamlib).
                Defaults to 9600 (1200 for ICR7000).

        STOPBITS Number of "stop" bits on the serial data (default=2)
                 (Not required for Hamlib)

        FREQUENCY Initial receive frequency in Hz, e.g. "144925000"

        OFFSET  "Tuning Offset" in PPM between requested frequency
                and actual frequency, in case the rig's reference
                crytal has drifted.

        MODE    Initial modulation mode:
                (Not all radios support all types)
                "USB", "LSB", "SSB", "DSB" "CW", "CWR", "RTTY",
                "RTTYR", "AM", "FM", "NFM", "WFM", "AMS", "PKTLSB",
                "PKTUSB", "PKTFM", "ECSSUSB", "ECSSLSB", "FAX",
                "SAM", "SAL", "SAH", "DATA, "DIG"

        SQUELCH Initial Squelch level (0-255)
                0=fully open, 255=fully closed

        VOLUME  Initial Audio volume (0-255) 0=min, 255=max

        TXFREQ  Initial Transmission frequency in Hz
                (if different to receive)

        PTTMETHOD How the PTT is controlled:
                0        Undefined
                1        Serial RTS
                2        Serial DTR
                3        CM108 HID
                4        CAT, CI5, FLEX etc
                5        GPIO pin (Pi only)

        RXAUDIODEV Device for inputting audio from radio to node,
                for example: "RXAUDIODEV=/dev/dsp2"

        Some of the values are "initial" values, that can be changed
        by the RADIO command during run-time, for example FREQUENCY,
        VOLUME, MODE etc.

EXAMPLE
        Example for PCR1000 receiver controlled via /dev/ttyUSB0,
        defaulting to 9600,8,n.2 with VOIP audio input via /dev/dsp2

        RADIO=1
                NAME=PCR-1000
                TYPE=3
                COM=/dev/ttyUSB0
                FREQUENCY=145.625
                MODE=FMn
                VOLUME=80
                SQUELCH=75
                RXAUDIODEV=/dev/dsp2
        ENDRADIO

SEE ALSO
        RADIO(1)       -- Rig control commands
        XROUTER.CFG(8) -- Main configuration file

RADIO(7)                  END OF DOCUMENT
