;*************************** Max Width *******************************
RADIO(1)              XROUTER REFERENCE MANUAL               21/9/2023

COMMAND
        RADIO -- Add/delete/list/control radios.

SYNOPSIS
        RA[dio] A[dd] <number> [options]
        RA[dio] C[ontrol] <number>
        RA[dio] D[rop] <number>
        RA[dio] L[ist]
        RA[dio] <number> [subcommand [args..]]

AVAILABILITY
        Sysop-only?

DESCRIPTION
        The RADIO command is used to add, remove, list and control
        radios that are connected to XRouter. 

        This can be used for controlling the operating parameters of
        a CAT-controlled radio that is being used for Packet, or for
        controlling a voice receiver or transceiver, e.g. for VOIP
        operations.

        Up to 5 radios can currently be supported. If there is any
        need for more, this can be changed in a future version.

        *** This system is unfinished and may change ***

        Radios are usually added at boot-time using RADIO definition
        blocks in XROUTER.CFG, but the RADIO command allows them to
        be added and removed during run-time.

        There are TWO ways to control a radio. The first is by using
        "one-shot" commands such as "radio 2 frequency 144800000"
        (see list below).

        The second method is to start a "control session" on a radio,
        which allows commands to be entered directly, e.g. "mode AM",
        "tx on" and so on. 

OPTIONS
        "RA[dio] **" lists the sub-commands, in case you forget.

        The A[dd] sub-command adds a radio to the list. The <number>
        must be within the range 1 to 5 inclusive. The [options] are
        yet to be decided.

        The D[rop] sub-command removes a radio from the radio list.

        The L[ist] sub-command lists the radios.

        The C[ontrol] command starts a "radio control" session,
        which allows direct entry of the various control commands
        listed below:

        Radio Control Commands:
        ~~~~~~~~~~~~~~~~~~~~~~~
        A[m]                 Select Amplitude Modulation mode
        CT[css] [frq | code] Display/set CTCSS frequency or code
        CW                   Select CW mode
        CWR                  Select 'reverse' CW mode
        D[own] [Hz]          Step frequency down by STEPsize or Hz
        E[xit]               Exit radio control session
        F[requency] [Hz]     Enquire or set radio's frequency
        FI[lter] [Hz]        Enquire or set IF filter width,
        FM                   Select Narrow FM mode,
        FMN                  Select Narrow FM mode
        FMW                  Select Wide FM mode
        LSB                  Select Lower Side Band mode,
        M[ode] [mode | LIST] Enquire or set modulation mode
        NFM                  Select Narrow FM mode
        O[ffset] [Hz]        Display / Set Repeater TX Offset
        P[ower] [on | off]   Enquire or set radio's on/off state
        S[hift] [- | 0 | +]  Display / Set Repeater TX Shift
        SQ[uelch] [0-100]    Enquire or set squelch level
        SSB                  Select Single Side Band mode
        ST[atus]             Display current settings
        STE[p] [Hz]          Enquire / set step size for UP/DOWN
        T[x] [on | off]      Begin / end transmissions
        TS[q] [freq | code]  Display/set Tone Squelch freq or code
        V[olume] [0-100]     Enquire or set audio volume
        U[p] [Hz]            Increase frequency by STEP or Hz
        USB                  Select Upper Side Band mode
        WFM                  Select Wide FM mode

        Not all radios support all commands. For example, the "TX"
        command is meaningless on a receiver, and "USB" is pointless
        on an FM-only radio.

SEE ALSO
        RADIO(7)       -- Rig control definition block
        XROUTER.CFG(8) -- Main configuration file

RADIO(1)                  END OF DOCUMENT
