;***********************|****|* Max Width *|***|*********************|
REJECT.SYS(8)           XROUTER REFERENCE MANUAL             29/3/2024

NAME
        REJECT.SYS -- Mail Rejection Control File.

DESCRIPTION
        The optional file REJECT.SYS, which resides in the PMS
        subdirectory, controls the "rejecting" of messages. It is
        used to reject unwanted types or categories of mail when they
        are offered (proposed) by other mailboxes. 

        The file is read "live" upon receipt of each proposal, so it
        can be edited on the fly, and changes take effect immediately.

FORMAT
        REJECT.SYS contains "rules" which control rejection of mail.
        Each rule must occupy a separate line. Blank lines and comment
        lines are allowed. The latter must begin with '#' or ';' in
        the leftmost column.

        Each rule consists of exactly 5 fields as follows:

            <type>  <to>  <from>  <at>  <size> 

            <type> is the message type, i.e. P, B, A, E, T, * etc.
            <to>   is the destination callsign or bulletin category.
            <from> is the sender's callsign.
            <at>   is the destination BBS or distribution area
            <size> is the maximum message size in bytes.

        Rules are case-independent, and wildcards are allowed.

        The exception is the <size> field where 0 = "don't care".
        If <size> is non-zero and the proposed message size is smaller
        than <size>, the message is allowed even if all the other
        fields match.

        Note that only FBB proposals include size, MBL ones don't.

        If the <at> field starts with a caret '^', it inverts the
        meaning of that field. e.g. "^GBR" rejects all "at" fields
        EXCEPT GBR.

OPERATION
        Incoming message proposals are tested against each rule in
        turn. If a rule matches all the message fields, the message is
        rejected.

EXAMPLE
        # Reject earthquake bulls of any size, from anyone: 
        # type  to      from   at     size
        # --------------------------------
          B     EQUAKE  *      *      0

SEE ALSO
        HOLD.SYS(8) -- Message Holding Control File.
        PMS(9)      -- About the Mailbox.

REJECT.SYS(8)                END OF DOCUMENT
