;*************************** Max Width *******************************
RESPTIME(7)            XROUTER REFERENCE MANUAL              26/9/2023

NAME
        RESPTIME -- AX25 Delayed Ack Time.

SYNOPSIS
        RESPTIME=<milliseconds>

DESCRIPTION
        RESPTIME is an optional PORT drectuive, used in XROUTER.CFG.

        It specifies the AX25 "T2" (delayed ack) time, i.e. the time
        to wait after receiving a frame before sending an ack, which
        allows multi-frame transmissions to be acknowledged with a
        single ack, increasing link efficiency. The value is in
        milliseconds, and the default is 1500.

        Resptime should be long enough for a link partner to transmit
        a full-sized information frame, i.e. approximately
        ((their_paclen * 10000) / RFbaudRate) millisecs, otherwise
        XRouter will send unnecessary ack frames.

        Too high a value will cause the link to be too "relaxed",
        whereas too low a value will cause too many acks. Both
        extremes reduce the link efficiency.

        The default RESPTIME of 1500 milliseconds is OK for 1200 baud
        with paclen=120, but 2200 would be more appropriate if their
        paclen was 256. At 9600 baud, or on AXUDP links, 200 ms is
        probably adequate.

        The value can be changed "on the fly" using the command of
        the same name.

EXAMPLE:
        RESPTIME=2000   ; 2 seconds 

SEE ALSO
        FRACK(7)       -- Frame Acknowledgement Time.
        RESPTIME(1)    -- Display / Set AX25 Delayed Ack Time.
        PACLEN(7)      -- Maximum Packet Length.
        PORTS(6)       -- Ports in XRouter.
        XROUTER.CFG(8) -- Main Configuration File.

RESPTIME(7)                  END OF DOCUMENT
