;*************************** Max Width *******************************
RESPTIME(1)            XROUTER REFERENCE MANUAL              26/9/2023

COMMAND
        RESPTIME -- Display / Set L2 delayed ack time for port.

SYNOPSIS
        RESPTIME <port> [millisecs]

AVAILABILITY
        This is a sysop-only command.

DESCRIPTION
        The RESPTIME command allows the value of the AX25 T2 (delayed 
        ack) time for a port to be displayed or altered.

OPTIONS
        If a single numeric argument is supplied, the current value 
        for that port number is displayed.

        If two numeric arguments are supplied, the first specifies
        the port number, and the second specifies the new value for
        the parameter.  The new setting remains in force until
        changed, or until XRouter is restarted, in which case the
        value specified by RESPTIME in the relevant PORT block in
        XROUTER.CFG is reapplied.

EXAMPLE
        RESPTIME 3       - Display current setting for port 3
        RESPTIME 3 150   - Set port 3 resptime to 1500 millisecs

NOTES
        The RESPTIME parameter specifies how long XRouter waits,
        after receiving a frame, before sending an ack for that 
        frame.  It helps to improve the efficiency by reducing 
        unnecessary acks.  It allows a single ack to be sent when a 
        transmission contains several frames, instead of acking each 
        frame in turn.

        The value must therefore be at least the length of time it 
        takes the link partner to transmit a single packet.  At 1200
        bauds (120 bytes/sec) a 120 byte packet lasts 1 second, a 180
        byte packet lasts 1500 millisecs and a 256 byte packet lasts
        just over 2 seconds.  Therefore RESPTIME should reflect the
        PACLEN used by the link partner.  1500 millisecs is a good
        compromise, but if the other end regularly uses high paclens,
        2000 or 2500 ms would be more appropriate.

        At 9600 baud, or on AXUDP links, 200 millisecs is probably
        adequate.

        Too high a value will cause the link to be too "relaxed", 
        whereas too low a value will cause too many acks.  Both 
        extremes reduce the link efficiency.

SEE ALSO
        FRACK(1)       -- Frame Acknowledgement Time.
        PACLEN(1)      -- Maximum Packet Length.
        SLOTTIME(1)    -- CSMA Interval Time
        RESPTIME(7)    -- AX25 Delayed Ack Time.
        XROUTER.CFG(8) -- Main Configuration File.

RESPTIME(1)                  END OF DOCUMENT
