;***********************|****|* Max Width *|***|*********************|
REST-BLOG(9)            XROUTER REFERENCE MANUAL             26/9/2023

NAME
        REST-BLOG -- REST Interface to Sysop's Blog.

DESCRIPTION
        The sysop's blog may be operated via a REST interface.

        For POST, the Content-Type: header MUST be "application/json".

        This facility is incomplete. The curently available
        functionality is documented in the next section.

OPTIONS
        a) Retrieve List of Blog Posts:
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        Request-Type: GET
        Request-URL:  api/v1/blog/posts

        If successful, the response is an un-named JSON array of
        objects, each objct containing the following fields:

        Name          Type      Description
        -----------------------------------------------------------
        "id"          integer   Article/post number.
        "rcvd"        string    Date/time of message creation (*).
        "size"        integer   Length of the blog text in bytes.
        "from"        string    Callsign of the post's creator.
        "subject"     string    Topic of the post (32 chars max)

        (*) in format "Mon, 14 Sep 1997 23:47:00 GMT"

        b) Retrieve a Blog Post:
        ~~~~~~~~~~~~~~~~~~~~~~~~

        Request-Type: GET
        Request-URL:  /api/v1/blog/posts/{post-number}
        Example:      http://localhost:80/api/v1/blog/posts/21

        The response payload is an un-named JSON object containing
        the following fields:

        Name          Type      Description
        -----------------------------------------------------------
        "id"          integer   Article/post number.
        "rcvd"        string    Date/time of message creation (*).
        "size"        integer   Length of the blog text in bytes.
        "from"        string    Callsign of the post's creator.
        "subject"     string    Topic of the post (32 chars max)
        "text"        string    Body of the post (plain ASCII)

        (*) in format "Mon, 14 Sep 1997 23:47:00 GMT"


        c) Post a Blog Article / Reply:
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        Request-Type: POST
        Request-URL:  /api/v1/blog/posts

        The payload must be a JSON object containing the following
        fields:

        Name          Type      Description
        -----------------------------------------------------------
        "sender"      string    Callsign of sender
        "replyto"     integer   No. of msg being replied to (0=new)
        "subject"     string    Subject of the post (32 chars max)
        "text"        string    Body of the post (unlimited size)

        Response: {"id": msg-number }

EXAMPLE
        curl -X POST http://localhost:80/api/v1/blog/posts \
        -H "Content-Type: application/json" -d '{\
        "sender": "G8PZT", "replyto": 0, \
        "subject": "test of post via REST", \
        "text": "Test of blog posts via REST interface"}' 

LIMITATIONS
        The blog's REST interface is only a proof-of-concept at this
        stage. It does not yet allow article deletion, "liking" of
        articles, or retrieval of replies. Those functions will be
        added in a future version

SEE ALSO
        BLOG(1)      -- Access Sysop's Blog.
        BLOGFLAGS(7) -- Options For Sysop's Blog.
        MQTT-BLOG(9) -- MQTT Interface to Blog.
        MQTT-SRV(9)  -- MQTT Server / Broker.

REST-BLOG(9)                 END OF DOCUMENT
