;***********************|****|* Max Width *|***|*********************|
REST-NETROM(9)          XROUTER REFERENCE MANUAL             26/9/2023

NAME
        REST-NETROM -- REST API for NetRom Subsystem.

DESCRIPTION
        Net/Rom status and information can be retrieved using the
        REST API.

        Requests are made using HTTP, and the data is returned in
        JSON (JavaScript Object Notation) format.

        The base URL for such interactions is "/api/v1/netrom".

        Only HTTP "GET" requests are currently supported by the
        netrom API.

OPTIONS
        a) Retrieve List of Nodes:

            GET /api/v1/netrom/nodes


        b) Display Information for Specific Node:

            GET /api/v1/netrom/nodes/{id}	- 

            ({id} is the node callsign)


        c) Display List of Neighbour Routes:

            GET /api/v1/netrom/routes


        d) Display Information for Specific Route:

            GET /api/v1/netrom/routes/{id}


        e) Display List of Layer 4 Circuits:

            GET /api/v1/netrom/circuits
	

RETURNS
        If the request is successful, the HTTP response code is 200 OK
        and the response payload is in JSON format, as detailed below:

        a) Nodes List

           The response payload is a JSON array, which may be empty.
           Each array element is a JSON object which contains at least
           the following fields:

           Name     Type     Description
           ----------------------------------------------------
           "id"     string   Callsign of node
           "alias"  string   Alias of node

        b) Specific Node:

           The response payload is a JSON object which contains at
           least the above 2 fields, plus some or all of the
           following fields:

           Name       Type     Description
           ----------------------------------------------------
           "qual"     integer  NetRom "quality" metric
           "rtt"      number   Round Trip Time in seconds (*)
           "hops"     integer  Links between here & target (*)
           "sent"     integer  Frames from us, addressed to that node
           "rcvd"     integer  Frames to us, addressed from that node
           "queue"    integer  L3 frames queued for that node
           "position" string   Node's position in APRS format
           "locator"  string   Node's Maidenhead locator
           "qth"      string   Town, county etc
           "ipaddr"   string   44-net IP address & bits
           "tcp"      integer  44-net Telnet port
           "software" string   Software type
           "version"  string   Software version

            (more fields to be added)

            (*) Zero values of "hops" and "rtt" indicate that they
                have not yet been measured.

        c) Routes List:

           The response payload is a JSON array, which may be empty.
           Each array element is a JSON object which contains at least
           the following fields:

           Name     Type      Description
           ----------------------------------------------------
           "id"	    integer   Unique identifier for this route
           "port"   integer   Port number used by this route
           "call"   string    Callsign of neighbour node
           "qual"   integer   Assigned NetRom "quality" of route
           "sntt"   number    Smoothed Neighbour Trip Time in secs
           "lock"   bool      Route is sysop-locked (true / false)
           "state"  string    "closed", "opening", "open" or "failed"
           "nodes"  integer   No. of nodes routed via this neighbour

           The list may be modified using options in the query string.

           The "port" option can be used to show only the routes
           using a specified PORT, like this:

                /api/v1/netrom/routes?port=2

           Extra information may be displayed using the "detail"
           option, either as a decimal number like this:

               /api/v1/netrom/routes?detail=3

           or as a comma-delimited list of mnemonics, like this:

               /api/v1/netrom/routes?detail=inp,rty,arq

           The extra details, their mnemonics and numbers are listed
           below:

           Mnemonic "l2" - L2 Parameters (+1)

           Name        Type      Description
           ----------------------------------------------------
           "maxframe"  integer   L2 "window" size
           "frack"     integer   Frame Acknowledgement time
           "paclen"    integer   Maximum packet length (bytes)

           Mnemonic "inp" - INP3 Values (+2)

           Name        Type      Description
           ----------------------------------------------------
           "maxtt"     integer
           "thrmaxtt"  integer
           "maxhops"   integer
           "flags"     integer
           "thrsntt"   number
           "inpnodes"  integer,

           Mnemonic "rty" - Frame Counts and Retry Rates (+4)

           Name        Type      Description
           ----------------------------------------------------
           "sent"      integer
           "resent"    integer
           "rtyave"    number
           "rtynow"    number
           "rtymax"    number
           "rtymaxtm"  integer   Time when rty-max occurred

           Mnemonic "rat" - Throughputs, channel load etc (+8)

           Name        Type      Description
           ----------------------------------------------------
           "uptime"    number
           "txmean"    integer
           "txbest"    integer
           "txpeak"    integer
           "loadave"   integer

           Mnemonic "arq" Automatic Route Quality Calculations (+16)

           Name        Type      Description
           ----------------------------------------------------
           "qualave"   integer   Moving average quality
           "qualmin"   integer   Minimum quality
           "qualmax"   integer   Maxinum quality
           "qualdev"   integer   Standard deviation of quality

           Mnemonic "tim" - Times (+32)

           Name        Type      Description
           -------------------------------------------------------
           "bcrcvd"    integer   Time of last rcvd nodes broadcast
           "lasthrd"   integer   Time of last received frame


        d) Specific Route:

           The response is a single JSON object as detailed in (c)


        e) List of L4 Circuits:

           The response payload is a JSON array, which may be empty.   
           Each array element has at least the following fields:

           Name		Type	Description
           ----------------------------------------------------
           "remote"     string  Remote address: user@node:circuit
           "local"      string  Local L4 address + our_circuit no.
           "direction"  string  "incoming" / "outgoing"
           "service"    number  L4X "service number", e.g. 80=http
           "state"      string  Connection state (see below)
           "txq"        number  Bytes queued for transmission
           "rxq"        number  Bytes queued for reception
           "rtt"        number  Smoothed round trip time (ms)
           "tries"      number  Retry count for current event
           "timeout"    number  Layer 4 timeout interval in secs
           "conTmr"     number  Secs left until next timeout
           "chkTmr"     number  Secs left on chocke timer
           "ackTmr"     number  Secs left on delayed ack timer
           "remBusy"    bool    Remote end is busy


           Connection states:
           ~~~~~~~~~~~~~~~~~~
           0 - Disconnected
           1 - Awaiting Connect ACKnowledgement
           2 - Connected & ready to pass data
           3 - We requested disconnect, awaiting DACK
           4 - Waiting for session layer to dispose
           5 - Our end wants to close after data is sent


ERROR CODES
        If the request is not successful, one of the following HTTP
        error codes is returned:

            Code                    Meaning
            --------------------------------------------------
            400 Bad Request         Invalid resource specifier
            404 Not Found           Specified API not found
            415 Unsupported Media   POST data was not JSON
            500 No Resources        No memory, try again later


EXAMPLES

	GET /api/v1/netrom/nodes/g8pzt
	GET /api/v1/netrom/routes?port=3
	GET /api/v1/netrom/routes?port=4&options=255

        Example Response for /api/v1/netrom/routes:

          [
            {
              "id": 1,
              "port": 4,
              "call": "G8PZT",
              "qual": 10,
              "sntt": 0.03,
              "lock": false,
              "state": "open",
              "nodes": 66
            },
            {
              "id": 2,
              "port": 6,
              "call": "G8PZT-14",
              "qual": 10,
              "sntt": 0.60,
              "lock": false,
              "state": "open",
              "nodes": 2
            }
          ]

        Example Response for /api/v1/netrom/nodes

          [
            {
              "id": "SP2L-14",
              "alias": "2LJNOS"
            },
            {
              "id": "ZL2AQY-2",
              "alias": "AQYNOD"
            },
            {
              "id": "N2NOV-7",
              "alias": "ARECS"
            },
            {
              "id": "MB7NBA",
              "alias": "BAMPTN"
            }
          ]


        Example Response for /api/v1/netrom/node/g8pzt:

          {
            "id": "G8PZT",
            "alias": "KIDDER",
            "qual": 10,
            "rtt": "0.12",
            "hops": "1",
            "frames": 61,
            "queue": 0,
            "position": "5224.00N 00215.00W",
            "locator": "IO82VJ",
            "qth": "Kidderminster, Worcestershire, U",
            "ipaddr": "44.136.16.50/32",
            "tcp": 23,
            "software": "XRPi",
            "version": "503d"
          }

        Example Response for /api/v1/netrom/circuits:

          [
            {
              "remote": "G8PZT-8@G8PZT-8:0eaa",
              "local": "G8PZT-9:0001",
              "direction": "incoming",
              "state": 2,
              "txq": 0,
              "rxq": 0,
              "rtt": 91,
              "tries": 0,
              "timeout": 120,
              "conTmr": 121,
              "chkTmr": 0,
              "ackTmr": 0,
              "remBusy": false
            },
            {
              "remote": "VK2DOT-1@VK2DOT-1:0167",
              "local": "G8PZT-4:0002",
              "direction": "incoming",
              "state": 2,
              "txq": 0,
              "rxq": 0,
              "rtt": 0,
              "tries": 0,
              "timeout": 120,
              "conTmr": 120,
              "chkTmr": 0,
              "ackTmr": 0,
              "remBusy": false
            }
          ]


Routes with all options

[
{
"id": 1,
"port": 6,
"call": "G8ASO-7",
"qual": 180,
"sntt": 0.00,
"lock": true,
"state": "failed",
"nodes": 0,
"maxframe": 3,
"frack": 7000,
"paclen": 256,
"maxtt": 5000,
"thrmaxtt": 10000,
"maxhops": 30,
"flags": 1,
"thrsntt": 0.00,
"inpnodes": 1,
"sent": 0,
"resent": 0,
"rtyave": 0,
"rtynow": 0.00,
"rtymax": 0.00,
"uptime": 4.4,
"txmean": 0,
"txbest": 0,
"txpeak": 0,
"loadave": 0,
"qualave": 0,
"qualmin": 0,
"qualmax": 0,
"qualdev": 0
},
{
"id": 2,
"port": 4,
"call": "G8PZT",
"qual": 10,
"sntt": 0.03,
"lock": false,
"state": "open",
"nodes": 73,
"maxframe": 3,
"frack": 7000,
"paclen": 256,
"maxtt": 5000,
"thrmaxtt": 5000,
"maxhops": 30,
"flags": 14,
"thrsntt": 0.18,
"inpnodes": 1,
"sent": 91,
"resent": 0,
"rtyave": 0,
"rtynow": 0.00,
"rtymax": 0.00,
"uptime": 98.1,
"txmean": 328,
"txbest": 2034,
"txpeak": 2034,
"loadave": 21,
"qualave": 252,
"qualmin": 252,
"qualmax": 252,
"qualdev": 0,
"bcast-rcvd": 1710514580,
"last-heard": 1710515203
}
]

SEE ALSO
        

REST-NETROM(9)               END OF DOCUMENT
|