;***********************|****|* Max Width *|***|*********************|
REST-PMS(9)             XROUTER REFERENCE MANUAL             23/3/2024

NAME
        REST-PMS -- REST Interface to Personal Message System.

DESCRIPTION
        The PMS may be operated via a REST interface, e.g.
        using a "curl" command.

        The request type is either GET (to request data from the
        PMS) or POST (to write data to the PMS). For POST, the
        "Content-Type:" header must be "application/json", and
        the payload must be in JSON format.

        This facility is incomplete. The currently available
        functionality is documented in the next section.

OPTIONS
        a) Retrieve List of Messages:
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        Request-Type: GET
        Request-URL:  api/v1/mail/msgs
        URL Options:  offset   - from "start" of list, default 0
                      maxitems - default 500
                      to       - callsign or category
                      at       - Distribution, e,g GBR
                      from     - Sender's callsign
                      subject  - string to match in subject
                      fwd/rvs? - to be added?

        If successful, the response is an un-named JSON array of
        objects, each object containing the following fields:

        Name          Type      Description
        -----------------------------------------------------------
        "id"          integer   Message number.
        "mid"         string    Message ID (MID or BID)
        "rcvd"        integer   Date/time of message reception (*1).
        "size"        integer   Length of the message body in bytes.
        "type"        string    Type of message: (A, P, B, E, T etc)
        "status"      string    Message status: (R, F, U etc) (*2)
        "to"          string    Destination address (*3)
        "from"        string    Callsign of the message's creator.
        "subject"     string    Message subject (32 chars max)
        "links"       object    Contains link to read the message (*4)

        (*1) in Unix time, i.e seconds since 1st Jan 1970 UTC
        (*2) type and status may in future be unambiguous words
        (*3) e.g. "g8pzt", "all@gbr", "g8pzt@gb7pzt.#24.gbr.eu"
        (*4) e.g. {"view": "/api/v1/mail/msgs/803"}

        Note that messages are listed in REVERSE order, i.e. most
        recent first.

        b) Retrieve a Message:
        ~~~~~~~~~~~~~~~~~~~~~~

        Request-Type: GET
        Request-URL:  api/v1/mail/msgs/{msg-number}
        Example:      http://localhost:80/api/v1/mail/msgs/21

        The response payload is an un-named JSON object containing
        the following fields:

        Name          Type      Description
        -----------------------------------------------------------
        "id"          integer   Message number.
        "mid"         string    Message ID (MID or BID)
        "rcvd"        integer    Date/time of message reception (*1).
        "size"        integer   Length of the message body in bytes.
        "type"        string    Type of message: (A, P, B, E, T etc)
        "status"      string    Message status: (R, F, U etc) (*2)
        "to"          string    Destination address (*3)
        "from"        string    Callsign of the message's creator.
        "subject"     string    Message subject (32 chars max)
        "text"        string    Body of the message (*4)

        (*1) in Unix time, i.e seconds since 1st Jan 1970 UTC
        (*2) type and status may in future be unambiguous words
        (*3) e.g. "g8pzt", "all@gbr", "g8pzt@gb7pzt.#24.gbr.eu"
        (*4) Message body includes all RFC822 and routing headers


        c) Post a Message:
        ~~~~~~~~~~~~~~~~~~

        Request-Type: POST
        Request-URL:  /api/v1/mail/msgs

        The payload must be a JSON object containing the following
        fields:

        Name          Type      Description
        -----------------------------------------------------------
        "from"        string    Callsign of sender
        "to"          string    Destination (see below)
        "type"        string    Only "P" or "B" at present
        "subject"     string    Subject of message (32 chars max)
        "text"        string    Body of the message

        For private messages the destination may be just a callsign,
        or <callsign>@<hierarchical-address>. For bulletins it may
        be simply <topic> or <topic>@<distribution>. For email it is
        <user>@<host>.

        The response is a JSON object containing the number of the
        newly created post, for example: {"id": 22}

EXAMPLE
        curl -X POST http://localhost:80/api/v1/mail/msgs \
        -H "Content-Type: application/json" -d '{\
        "from": "G8PZT", "to": "all@gbr", \
        "type": "B",
        "subject": "XRouter 503 coming soon", \
        "text": "New XRouter expected to be completed by Xmas"}' 

LIMITATIONS
        The PMS's REST interface is only a proof-of-concept at this
        stage, and some details may change. More functionality will
        be added in a future version

SEE ALSO
        PMS(1)      -- Access Personal Message System.
        MQTT-PMS(9) -- MQTT Interface to PMS.
        PMS(9)      -- About the Personal Mesaage System

REST-PMS(9)                  END OF DOCUMENT
