;***********************|****|* Max Width *|***|*********************|
REST-WALL(9)            XROUTER REFERENCE MANUAL             26/9/2023

NAME
        REST-WALL -- REST Interface to Message Wall.

DESCRIPTION
        The message wall may be operated via a REST interface, e.g.
        using a "curl" command.

        The request type is either GET (to request data from the
        wall) or POST (to write data to the wall). For POST, the
        "Content-Type:" header MUST be "application/json", and
        the payload MUST be in JSON format.

        This facility is incomplete. The curently available
        functionality is documented in the next section.

OPTIONS
        a) Obtain List of Wall Posts:
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        Request-Type: GET
        Request-URL:  /api/v1/wall/posts

        If successful, the response is an un-named JSON array of
        objects, each objct containing the following fields:

        Name          Type      Description
        -----------------------------------------------------------
        "id"          integer   Article/post number.
        "rcvd"        string    Date/time of message creation (*).
        "size"        integer   Length of the text portion in bytes.
        "from"        string    Callsign of the post's creator.
        "text"        string    Body of the post (plain ASCII)

        (*) in format "1997-09-14T23:47:00Z"

        b) Retrieve a Wall Post:
        ~~~~~~~~~~~~~~~~~~~~~~~~

        Request-Type: GET
        Request-URL:  api/v1/wall/posts/{post-number}
        Example:      http://localhost:80/api/v1/wall/posts/17

        The response payload is an un-named JSON object containing
        the following fields:

        Name          Type      Description
        -----------------------------------------------------------
        "id"          integer   Article/post number.
        "rcvd"        string    Date/time of message creation (*).
        "size"        integer   Length of the text in bytes.
        "from"        string    Callsign of the post's creator.
        "text"        string    Body of the post (plain ASCII)

        (*) in format "Mon, 14 Sep 1997 23:47:00 GMT"


        c) Post a Wall Message / Reply:
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        Request-Type: POST
        Request-URL:  /api/v1/wall/posts

        The payload must be a JSON object containing the following
        fields:

        Name          Type      Description
        -----------------------------------------------------------
        "sender"      string    Callsign of sender
        "text"        string    Body of the post (unlimited size)

        The response is a JSON object containing the number of the
        newly created post, for example: {"id": 22}

LIMITATIONS
        The wall's REST interface is only a proof-of-concept at this
        stage. It does not yet allow article deletion, "liking" of
        articles, or retrieval of replies. Those functions will be
        added in a future version

SEE ALSO
        WALL(1)      -- Access Message Wall / Guestbook.
        WALLFLAGS(7) -- Options For Message Wall.
        MQTT-WALL(9) -- MQTT Interface to Wall.
        MQTT-SRV(9)  -- MQTT Server / Broker.

REST-WALL(9)                 END OF DOCUMENT
