;***********************|****|* Max Width *|***|*********************|
REST-WX(9)              XROUTER REFERENCE MANUAL             14/3/2024

NAME
        REST-WX -- REST Interface to Weather System.

DESCRIPTION
        Weather data stored on XRouter can be retrieved using the
        REST API.

        Requests are made using HTTP, and the data is returned in
        JSON (JavaScript Object Notation) format.

        The base URL for such interactions is "/api/v1/weather".

        Only HTTP "GET" requests are currently supported by the
        weather API.

OPTIONS
        a) Retrieve List of Weather Stations:

           Request-Type: GET
           Request-URL:  /api/v1/weather/stations

        b) Retrieve Weather Data From a Specific Station

           Request-Type: GET
           Request-URL:  /api/v1/weather/stations/{id}

           {id} is a station identifier, usually callsign, or LOCAL
           for observations entered into the node from a local sensor.


RETURN VALUES
        If successful, the HTTP response code is 200 and the payload
        contains the response in JSON format, as detailed below:

        For Stations List:

        The response is an anonymous JSON array of objects, each object
        containing the following fields:

        Name          Type      Description
        -----------------------------------------------------------
        "id"         string   Station id, e.g. "G8PZT" or "LOCAL"
        "lat_deg"    number   Latitude of wx station in degrees
        "lon_deg"    number   Longitude of wx station in degrees
        "dist_km"    number   Distance from our node in kilometers
        "dir_deg"    number   Direction from our node in degrees
        "dt":        integer  Observation time, in secs since 1/1/70

        For a Specific Station:

        The response is an anonymous JSON object, containing the above
        fields plus some of all of the following weaher data:

        Name             Type     Description
        -----------------------------------------------------------
        "observed"       string  Date and time of observation (*1)
        "pressure_mb"    number  Air pressure in millibars
        "temperature_C"  number  Air temperature in degrees C
        "humidity"       number  Relative Humidity in percent
        "dewpoint_C"     number  Dew point in degrees Centigrade
        "heat_index_C"   number  Heat index in deg Centigrade
        "wind_chill_C"   number  Wind Chill in degrees Centigrade
        "wind_mph"       number  Wind speed in miles per hour
        "wind_dir_deg"   number  Wind direction in degrees
        "gust_mph"       number  Wind gust speed in miles per hour
        "raintoday_mm"   number  Total rain since midnight in mm
        "rain1h_mm"      number  Current rainfall rate mm/hour
        "rain24h_mm"     number  Total rain in past 24 hours in mm
        "sunrise"        string  Sunrise time at the station hh:mm
        "sunset"         string  Sunset time at the station hh:mm
        "daylight_hours" number  Hours between sunrise and set

	(*1) As "dt" but human-readable e.g. 2024-03-14T15:19:59Z

        For Local Sensor Only:

        If there is a local weather sensor feeding XRouter, the
        response containing the above fields plus some or all of the
        following extra data, depending on the capabilities of the
        sensor:

        Name             Type      Description
        -----------------------------------------------------------
        "rain_max_mm_hr"   number  Maximum rain rate today mm/hour
        "press_max_mb"     number  Maximum air pressure today 
        "press_min_mb"     number  Minimum air pressure today
        "temp_max_C"       number  Maximum temperature today
        "temp_min_C"       number  Minimum temperature today
        "humid_max"        number  Maximum humidity today
        "humid_min"        number  Minimum humidity today
        "wind_ave_mph"     number  Moving average wind speed
        "wind_max_mph"     number  Maximum wind speed totay
        "gust_max_mph"     number  Maximum gust speed today
        "wind_dir_ave_deg" number  Moving average wind direction
        "wind_run_miles"   number  Total wind run today, in miles
        "light_w_sqm"      number  Current light level, watts/sq m
        "light_max_w_sqm"  number  Maximum temperature today
        "UV_index"         number  Current UV index
        "UV_index_max"     number  Maximum UV index today

              ("today" means since midnight GMT)

ERROR CODES
        400 Bad Request         Invalid resource specifier
        404 Not Found           Specified API not found
        415 Unsupported Media   POST data was not JSON
        500 No Resources        No memory, try again later

EXAMPLES
        a) Stations List:

          [
            {
              "id": "LOCAL",
              "lat_deg": 50.0935,
              "lon_deg": -5.0850,
              "dist_km": 0,
              "dir_deg": 0,
              "dt": 1710395654
            },
            {
              "id": "G8PZT",
              "lat_deg": 52.2400,
              "lon_deg": -2.1500,
              "dist_km": 0,
              "dir_deg": 0,
              "dt": 1710394799
            }
          ]

        b) Specific Station:

          {
            "id": "G8PZT",
            "lat_deg": 52.2400,
            "lon_deg": -2.1500,
            "dist_km": 0,
            "dir_deg": 0,
            "dt": 1710425999,
            "observed": "2024-03-14T15:19:59Z",
            "temperature_C": 13.3,
            "humidity": 51,
            "dewpoint_C": 3.5
            "wind_mph": 0.0,
            "wind_dir_deg": 202,
            "gust_mph": 1.0,
            "sunrise": "07:25",
            "sunset": "19:12",
            "daylight_hours": 11.78
          }

       c) Local Weather

          {
            "id": "LOCAL",
            "lat_deg": 50.0875,
            "lon_deg": -5.075,
            "dist_km": 0,
            "dir_deg": 0,
            "dt": 1710395899,
            "observed": "2024-03-14T06:58:19Z",
            "pressure_mb": 1006,
            "temperature_C": 10.9,
            "humidity": 94,
            "wind_mph": 16.6,
            "wind_dir_deg": 147,
            "gust_mph": 20.6,
            "rain_max_mm_hr": 0,
            "press_max_mb": 1010.1,
            "press_min_mb": 1005.9,
            "temp_max_C": 11,
            "temp_min_C": 10.6,
            "humid_max": 95,
            "humid_min": 94,
            "dewpoint_C": 9.7,
            "wind_ave_mph": 11.6,
            "wind_max_mph": 23.3,
            "gust_max_mph": 34.4,
            "wind_dir_ave_deg": 139,
            "wind_run_miles": 58.2,
            "light_w_sqm": 0,
            "light_max_w_sqm": 0,
            "UV_index": 0,
            "UV_index_max": 0,
            "sunrise": "07:35",
            "sunset": "19:25",
            "daylight_hours": 11.83
          }

SEE ALSO
        WX(1)     -- Display Weather Information.
        WXFILE(7) -- Weather Import File.
        WX(9)     -- Weather Information System.
        WX-SVC(9) -- NetRomX Weather Service
        

REST-WX(9)                   END OF DOCUMENT
