;***********************|****** Max Width *****|*********************|
RHPPORT(7)             XROUTER REFERENCE MANUAL              27/9/2023

NAME
        RHPPORT -- TCP Port for RHP Server.

SYNOPSIS
        RHPPORT=n1 [n2] (where n1 and n2 are 0 to 65535)

DESCRIPTION
        RHPPORT is an optional "global" directive used in
        XROUTER.CFG.

        If present, it specifies the TCP "service port" number used
        by the RHP (Remote Host Protocol) server. If not present,
        the default is 9000.

        The RHP server provides a socket-like application interface
        to various layers within XRouter.

OPTIONS
        If a single argument is supplied, e.g. "RHPPORT=80", it
        applies to whichever TCP/IP stack(s) XRouter is using.

        If TWO arguments are supplied, e.g. "RHPPORT=80 8080", the
        first argument applies to the XRouter stack and the second to
        the host system's stack. The numbers must be separated by
        whitespace

        Setting RHPPORT to zero on a stack prevents TCP connections
        to the RHP server via that stack.

        See TCP-PORTS(6) for more information on this and the caveat
        below.

CAVEATS
        In order to use port numbers below 1024 on the Linux stack,
        XRouter must be run from a root account, or given the
        CAP_NET_BIND_SERVICE capability.

SEE ALSO
        CAPFLAGS(6)    -- Capability Flags.
        RHP-SRV(9)     -- Remote Host Protocol server.
        TCP-PORTS(6)   -- TCP Service Ports.
        XROUTER.CFG(8) -- Main Configuration File.

RHPPORT(7)           END OF DOCUMENT
