RIP(9)                  XROUTER REFERENCE MANUAL            18/10/2023

NAME
        RIP -- Routing Information Protocol.

DESCRIPTION
        Routing Information Protocol (RIP) allows IP routers to learn
        about each other's routing, similar to the way that NetRom
        exchanges nodes broadcasts.

        There are various versions of RIP, and XRouter currently
        implements RIP2 and RIP98. RIP2 is used for the IPEncap-based
        "44-net" network, and RIP98 was developed by G8BPQ specically
        for radio-based routers.  If there is a need for other
        flavours of RIP, they may be included in a later version.

        RIP98 works by sending its routing table to nominated peers
        at regular intervals, and accepting routing information from
        peers.  The routes learned by this means are added as
        temporary entries to the IP routing table.  These entries
        have a finite lifetime, and if not updated regularly they
        drop out of the routing table.

        Configuring XRouter to use RIP98
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        The following configuration commands are available:

              RIP ACCEPT      Remove a peer from the refuse list.
              RIP ADD         Add a peer to the broadcast list. (*)
              RIP DROP        Remove a peer from the broadcast list.
              RIP LEARN       Allow / disallow route learning. (*)
              RIP REFUSE      Ignore broadcasts from a peer. (*)
              RIP STATUS      Show status of RIP.
              RIP TIMEOUT     Specify lifetime of learned routes. (*)

        Commands marked (*) may be used in BOOTCMDS.SYS or
        IPROUTE.SYS to configure the system automatically.

        By default, RIP98 route learning is OFF, so you need to
        include at least a "RIP LEARN ON" command, to enable your
        system to learn routes from others.  Your neighbours also
        need to add your IP address to their RIP broadcast lists.

        If you wish to inform your neighbours of your existence and
        your routing capabilities, you need some RIP ADD commands,
        one for each neighbour to whom you wish to send RIP updates.

        If you have LEARN enabled, and there is a neighbour who is
        sending unwanted RIP updates to you, you may ignore them
        using RIP REFUSE.

        The RIP commands are explained in more detail in section 1 of
        this manual.

SEE ALSO
        RIP(1) -- Routing Interface Protocol Commands.

RIP(9)                      END OF DOCUMENT
