RIP(1)                  XROUTER REFERENCE MANUAL            18/10/2023

COMMAND
        RIP -- Routing Interface Protocol configuration commands.

SYNOPSIS
        RIP AC[cept] <ip_address>
        RIP A[dd] <ip_address> <secs>
        RIP D[rop] <ip_address>
        RIP L[earn] [ON | OFF]
        RIP R[efuse] <ip_address>
        RIP S[tatus]
        RIP T[imeout] [secs]

DESCRIPTION
        RIP allows IP routers to learn of each other's routing, in a 
        similar fashion to NetRom.  XRouter implements both RIP2,
        used by the IPEncap-based "44-net", and RIP98, which is a
        form optimised for radio, and the RIP commands are used to 
        configure the system.

OPTIONS
        Peers which have been added to the refuse list using the RIP 
        REFUSE command can be removed using RIP ACCEPT, allowing the 
        router to learn information from them.  <ip_address> is the
        IP address of the peer.

        RIP ADD adds a peer to the list of those who will receive RIP 
        transmissions from us.  The <secs> parameter specifies the 
        interval between transmissions, and should be chosen in 
        agreement with the peer, so that <secs> is approximately one
        quarter of the lifetime of their RIP entries.  This allows up 
        to 4 transmissions to be lost before the route is purged.

        RIP DROP removes a peer from the list of those who receive
        RIP transmissions from us.

        RIP LEARN turns route learning on or off.  By default, RIP98 
        route learning is OFF.  If no arguments are given, the
        current status is reported.  "ON" allows XRouter to learn
        routes from its RIP98 peers, and "OFF" prevents it.  I
        recommend enabling LEARN mode.

        RIP REFUSE is the opposite of ACCEPT.  It adds a peer to the 
        refuse list so broadcasts from that peer will be ignored.
        This command is provided in case you need to exclude a peer 
        which is advertising faulty routes.

        RIP STATUS displays various RIP98 parameters such as the list 
        of peers who receive broadcasts from us, the list of peers we 
        are ignoring, the timeout value, and the setting of learn 
        mode.

        RIP TIMEOUT is used to display and set the lifetime of
        learned routes.  Routes learned from peers have a finite
        lifetime.  If the route entry is not refreshed within this
        lifetime, it is removed from the routes table.  The timeout
        should preferably be 4 times the interval between broadcasts
        from peers, and the default is currently 4 hours.

EXAMPLES
        RIP ACCEPT 44.131.95.2
        RIP ADD 44.131.95.240 3600
        RIP DROP 44.131.90.6
        RIP LEARN ON
        RIP REFUSE 44.131.57.1
        RIP STATUS
        RIP TIMEOUT 14400

FILES
        The RIP ADD, LEARN, REFUSE and TIMEOUT commands may also be
        used within IPROUTE.SYS or BOOTCMDS.SYS.

AVAILABILITY
        Sysop-only.

SEE ALSO
        BOOTCMDS.SYS(8) -- Commands to Execute at Bootup.
        IPROUTE.SYS(8) -- IP Router Configuration File.

RIP(1)                      END OF DOCUMENT
