;***********************|****** Max Width *****|*********************|
RLOGINPORT(7)           XROUTER REFERENCE MANUAL             27/9/2023

NAME
        RLOGINPORT -- TCP Port for Remote Login Service.

SYNOPSIS
        RLOGINPORT=n1 [n2] (where n1 and n2 are 0 to 65535)

DESCRIPTION
        RLOGINPORT is an optional "global" directive used in
        XROUTER.CFG.

        If present, it specifies the TCP "service port" number used
        by the RLOGIN (Rmote Login) service. If not present, the
        default is 513.

        RLOGIN is a "remote login" facility for full sysop access via
        secure links.

OPTIONS
        If a single argument is supplied, e.g. "RLOGINPORT=513", it
        applies to whichever TCP/IP stack(s) XRouter is using.

        If TWO arguments are supplied, e.g. "RLOGINPORT=513 514", the
        first argument applies to the XRouter stack and the second to
        the host system's stack. The numbers must be separated by
        whitespace

        Setting RLOGINPORT to zero on a stack prevents TCP
        connections to the RLOGIN service via that stack.

        See TCP-PORTS(6) for more information on this and the caveat
        below.

CAVEATS
        In order to use port numbers below 1024 on the Linux stack,
        XRouter must be run from a root account, or given the
        CAP_NET_BIND_SERVICE capability.

SEE ALSO
        CAPFLAGS(6)    -- Capability Flags.
        RLOGIN(9)      -- Remote Login Service.
        TCP-PORTS(6)   -- TCP Service Ports.
        XROUTER.CFG(8) -- Main Configuration File.

RLOGINPORT(7)           END OF DOCUMENT
