ROUTES(1)               XROUTER REFERENCE MANUAL            18/8/2025

COMMAND
        ROUTES -- Add, Drop and List NetRom Routes.  

SYNOPSIS
        R[outes] [* | H | L | R | Q | T | X ] [portnum]
        R[outes] <portnum> [callsign]
        R[outes] A[dd]  <call> <port> <qual> [!] [V digis] [opts]
        R[outes] D[rop] <call> <port>
 
DESCRIPTION
        The ROUTES command, which may be abbreviated to "R", lists
        the immediately adjacent NetRom nodes, i.e. those who can be
        heard directly, providing those nodes are making NetRom nodes 
        broadcasts.

        For each "neighbour" node the display always shows the port
        number, the neighbour's callsign, the route quality, and the
        number of nodes accessible via that neighbour.

            G8PZT:KIDDER} Routes:
            Port Callsign  Qty Nod
            >  5 G4FPV     150  70!
            >  7 GB7PZT    250   1!
            >  8 GB7WV-12  100  32!
            >  9 GB7GH     150 104!
              10 GB7CL     150   1!
            > 11 GB7IPT-7  150   3!
              12 G1LOA-10  150   2!

        A chevron (>) in the left-most column indicates a route which
        is in use. A tilde (~) indicates that the connection is in
        the process of being established. An "x" indicates a failed
        route, and a blank space indicates a closed (but not failed)
        route.

        An exclamation mark (!) in the right-most column indicates
        that the data has been "locked in" by the sysop.

        Any additional information, displayed to the right of the
        above, depends on which additional option is supplied, as
        detailed in the next section.

OPTIONS
        Some of the options give identical output, because they were
        renamed, the old options being retained for backward
        compatability.

        If no options are specified, the output is similar to the
        example above.

        The following options don't display any routes:

            ?      displays the command syntax.
            *      displays a brief list of the available options.
            **     lists the options with brief descriptions.
            A[dd]  is used to add a route.
            D[rop] is used to remove a route.
            H[elp] lists the options with brief descriptions.

        Options which display routes and modify the display format
        are as follows:

            L[oad] displays traffic loading & connection percentage
            Q[ual] displays estimated route qualities
            R[etr] displays sent/resent frames & retry rates
            T[ime] displays trip times & settings for time metrics
            X[tra] displays running average & peak retry rates
            Y      is the same as T[ime] (deprecated)
            Z      is the same as L[oad] (deprecated)

        If the first or second option is a valid port number, only
        the information for that port is displayed.

        If the first option is a port number and the second option is
        a callsign, e.g. "R 2 G8PZT", a page is displayed containing
        all the information for that neighbour route. 

DETAILS
        L[oad] displays information about connection percentage and
               data throughputs, for example:

           Con%  Peak  Best  Mean  Load   Last heard
            98%  3024  3024   102     9  19/10 05:34

           Con%  - Percentage of time that link has been connected.
           Peak  - Max throughput in bytes/sec including resends
           Best  - Best mean throughput achieved, excluding resends
           Mean  - Running mean throughput in bytes/sec.
           Load  - Long term average throughput (TX+RX) in bytes/sec.
           Last  - Last date/time that any traffic used this route.

        
        Q[ual] displays the estimated route qualities, for example:

           Qual  Min  Max  Mdev
            245  240  252     1

           These are based on measurements of actual link
           performance, regardless of qualities specified by sysops.
           They are intended as a guide to help sysops make informed
           choices for link quality. The values shown are the
           smoothed calculated quality, the minimum and maximum
           calculated qualities, and the standard deviation of the
           mean.


        R[etr] displays the current MAXFRAME, FRACK and PACLEN
               settings, and retry rates, for example:

           Max  Frack  Pac    Sent  Resent  Rty%  Last bcast
             3   7000  256    4415    1296   29% 19/10 05:29

           Max    - Maxframe (maximum allowed unacked frames)
           Frack  - Frack (Frame Acknowledgement time) Millisecs
           Pac    - Paclen (maximum packet length in bytes)
           Sent   - Total information frames sent
           Resent - Information frames re-sent
           Rty%   - Retry rate in percent
           Bcast  - Date/time of neighbour's last nodes broadcast


        T[ime] displays information and settings concerned with
               temporal metrics, i.e those based on trip time:

           Tdr     Stt  Flg  Maxtt/hops 
            63    0.03   14   5000   30   5000

           The displayed values are as follows:

           Tdr    - Nodes learned from neighbour via temporal metrics
           Stt    - Smoothed Trip Time to the neighbour.
           Flg    - Flags, the sum of the following:

                      1 - Route locked in by sysop.
                      2 - Neighbour is INP3 compatible.
                      4 - Neighbour responds to our L3RTT probes.
                      8 - Neighbour is XRouter
                     16 - Automatic route quality enabled.

           MaxTT  - Max Trip Time allowed via this route.
           MaxHop - Max Hop count allowed via this route.

           The final figure is the neighbour's MaxTT setting, which
           may differ from ours.


        X[tra] displays extended information about the retry rates:

           Sent  Resent  Rty%   Now%   Max% @dd/mm hh:mm 
           4427    1301   29%  31.08  40.00  12/10 23:21 

           Sent   - Total information frames sent
           Resent - Information frames re-sent
           Rty%   - Long-term mean retry rate
           Now%   - Running average retry rate
           Max%   - Peak value of the running average
           @dd... - Date and time of the peak value

           The running average retry rate is more responsive to
           short-term variations (e.g. due to QRM on a link) than the
           long term mean.

           These stats often reveal links with low *mean* retry rates
           that display some surprising short term highs.
      

        A[dd] adds a new route or modifies an existing one. The
              arguments are as follows:

           <call> is the callsign of the neighbour node.

           <port> is the radio port via which the neighbour is
                  reached.

           <qual> is the netrom "quality" to use for that route.
                  A quality between 256 and 511 will instruct
                  XRouter to use "automatic" quality, with a starting
                  value of (qual-256). 

           [!] locks the entry to prevent it being overridden by
               learned information.

           [V digis] specifies a digipeated route, where "digis"
                     is a string of digipeater calls seperated by
                     commas, i.e. in the form "DIGI,DIGI,DIGI".

           [opts] are optional maxframe, frack, paclen, maxtt and
                  maxhops values to override the port defaults.
                  The format is:

                      [maxframe [frack [paclen [maxtt [maxhops]]]]]

                  i.e. in order to specify maxtt you must also
                  specify maxframe, frack and paclen  Use zero in
                  any field you don't wish to change.

EXAMPLES
         route add g8pzt 5 100
         route add g6yak 2 100 ! V G8EPR,G8NTU 5 7000
         route add g8klm 3 150 ! 0 0 245 2000 3
         route drop mb7uyl 14
         r 4       -- Display basic information for routes on port 4
         r 4 g8pzt -- Display detailed info for G8PZT on port 2
         r t 5     -- Display TDR information for routes on port 5

AVAILABILITY
        The ROUTES command is available to all users, but the ADD
        and DROP options are sysop-only.

SEE ALSO
        AUTOQUAL(9)  -- Automatic Route Quality
        NODES(1)     -- Display Nodes Tables.
        PERMLINKS(9) -- Permanent NetRom Neighbour Links.

ROUTES(1)                   END OF DOCUMENT
