;*************************** Max Width *******************************
RUNROOT(6)             XROUTER REFERENCE MANUAL              23/9/2023

NAME
        RUNROOT -- Running XRouter as Root?.

SYNOPSIS
        Running XRouter with super-user privileges is easier and
        more convenient than running it as an unprivileged user. But
        technically it is more of a security risk.

        This page explores some of the pros and cons or running
        XRouter as a privileged user or not. It is a work in
        progress...

DISCUSSION

        Running As Root:
        ~~~~~~~~~~~~~~~~

        If XRouter is "run as root" (i.e. from a root account), it
        has full access to the file system and sensitive processes.
        This makes life easier if you need to tinker with the
        operating system's configuration via XRouter's command
        interface.

        For example, imagine XRouter sitting on a remote hilltop as
        part of a Packet Radio network, but without Internet access.
        How would you set the time and date if it drifted? How would
        you make any changes to the PI's configuration, without going
        to site? There's no Internet connection, so you couldn't use
        VNC or SSH!

        Answer: If you can "connect" to XRouter over the AX25 packet
        network, and verify yourself as a sysop, you can use the DOS
        and SHELL commands to do most system maintenance, even over
        the slowest link. You could upload new versions using NFTP,
        or iff the AX25 links support TCP/IP, you might even be able
        to use XRouter's FTP server.

        But if XRouter is not running as "root", you would not be
        able to set the time or date, and you would not have write
        access to "sensitive" areas of the file system.

        The downside of running as root is that, in the unlikely
        event that a malicious actor cracks or guesses your password,
        he would have full access to the machine.

        This means he could delete all your stuff, or lock you out
        and use the machine as an attack tool.

        To get this into perspective however, XRouter has clocked up
        several years trouble-free service running as root,
        completely open to the Internet. Passwords are by far the
        weakest point, so make sure you use a strong one!

        Running Unprivileged:
        ~~~~~~~~~~~~~~~~~~~~~

        This is slightly less convenient, in that you have to tinker
        with capabilities and give some thought to what access you
        need to various parts of the system.

        But it is more secure. If someone cracked your password, they
        could only trash the XRouter part of your system.

        If you run unprivileged, you cannot change the date and time
        from the XRouter command line, and you cannot access
        privileged areas of the file system using FTP or the DOS
        emulator.

        You are also prevented from creating an EXTERNAL interface or
        performing any TCP/IP operations involving the LAN or
        localhost, unless you set CAP_NET_RAW on the program, and
        from opening low-numbered server ports on the kernal stack
        unless you set CAP_NET_BIND_SERVICE [ see CAPFLAGS(9) ].
 
SUMMARY
        Running As Root

          - Everything just works.
          - Theoretically less secure.
          - Sysop can set time and date from XRouter command line.
          - PZTDOS has full access to file system
          - FTP server has full access to file system. 

        Running As User

          - Theoretically more secure.
          - Can't access Ethernet/Wifi/localhost (*1)
          - Can't open server ports below 1024 on kernal stack (*2).
          - Sysop cannot set time or date from within XRouter
          - PZTDOS can't write to privileged parts of file system.
          - FTP server can't write to privileged parts of file system. 

            (*1) Needs CAP_NET_RAW
            (*2) Needs CAP_NET_BIND_SERVICE 

CAVEATS
        You can not use "sudo" to run XRouter as root, because the
        sudo session has a time limit. XRouter will run, but after a
        while it will stop responding to the keyboard. And it may
        bork if you use the "restart" command.

        (It is possible to change the sudo timeout on some Linux
        distros)
 
SEE ALSO
        CAPFLAGS(6)  -- Capability Flags
        IP-STACKS(6) -- IP Stacks in XRouter.
        TCP-PORTS(6) -- TCP Server Ports.
        LAN(6)       -- LAN Interfacing.

RUNROOT(6)               END OF DOCUMENT
