;***********************|****** Max Width *****|*********************|
SB(4)                   XROUTER REFERENCE MANUAL             29/3/2024

COMMAND
        SB -- Send Bulletin.

SYNOPSIS
        SB <topic> [ @ <area> ]

DESCRIPTION
        The SB (Send Bulletin) command is used to send a "bulletin",
        i.e. a message which can be read by anyone.

OPTIONS
        The non-optional <topic> field targets the bulletin at an
        intended audience, and can consist of any word, up to 6
        characters maximum, e.g. ALL  IBM  HELP  TCPIP  etc. Please
        use a meaningful <topic> field if possible.

        The optional [ @ <area> ] bit specifies the "target area" or
        "distribution area" for the bulletin. If a distribution area
        is specified, the bulletin is delivered to all other
        mailboxes within the specified area, otherwise the bulletin
        stays on this mailbox only. 

        The <area> or "at" field should consist of an area code that
        is known to other sysops, otherwise they won't know where to
        send it. Examples are:

            WMIDS - West midlands mailboxes
            FOURP - Mailboxes in the Fourpak area
            GBR   - All mailboxes in Great Britain
            EU    - All mailboxes in Europe (includes GBR)
            WW    - All mailboxes in the world.

        Please try to target your bulletin to the minimum area
        necessary. A bulletin advertising your local club night
        doesn't need to go worldwide!

EXAMPLES
        SB KRG          - Bull about local KRG club meeting
        SB IBM @ WMIDS  - Bull about IBM to west mids mailboxes.
        SB HELP @ GBR   - Ask everyone in Great Britain for help.

AVAILABILITY
        The SB command is available to all users.

SEE ALSO
        SP(4) -- Send Personal Message.
        SR(4) -- Send Reply to a Message.

SB(4)                       END OF DOCUMENT
