SCRIPT(9)               XROUTER REFERENCE MANUAL            17/10/2023

NAME
        SCRIPT -- Dialer Scripts

DESCRIPTION
        Assuming you have a port configured for modem use, DUN
        requires at least one dialler script, to control the dial and
        login sequence.

        Dialler scripts are ordinary text files containing script
        commands as detailed below, one per line.  Lines must not
        exceed 256 characters in length.  The script file can be named
        as you wish, for example you might like to name your AOL dial
        script "AOL.SCR".  You will need to use this name later to
        identify the script, so it makes sense to call it something
        meaningful, rather than "SCRIPT1.TXT".  Script files must
        reside in the same directory as the XRouter executable.

        DUN Script Commands Overview
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~

              CONTROL    Raise / lower RS232 DTR signal.
              MODE       Protocol to use upon successful login.
              PPP        PPP configuration commands.
              SEND       Send text.
              SLEEP      Temporary pause.
              WAIT       Wait for text in received data.


        DUN Script Commands In Detail
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        CONTROL - Raise / Lower RS232 DTR signal.

                Syntax: C[ontrol] <up | down>

                The CONTROL command is used to raise or lower the
                RS232 DTR (Data Terminal Ready) line.  Most modems
                require the DTR signal to be "up", and will disconnect
                or reset when it goes down.  Those modems which do not
                do this by default can usually be configured to do so
                by including "&D2" in the initialisation string.


        MODE  - Set protocol to use upon successful login.

                Syntax:  M[ode] <kiss | ppp | slip>
                Example: MODE PPP

                MODE specifies the protocol to use after your system
                has logged into the remote host, i.e. when the script
                ends without error.  It must precede the dialling and
                login sequence, and any protocol dependent commands,
                such as the PPP commands.


        PPP   - PPP configuration commands.

                Syntax:  P[pp] <idle | ipcp | lcp | log | pap> [arg]
                Example: PPP IDLE 300

                PPP commands are used to configure the PPP subsystem
                for the connection being established.  Note that
                within DUN scripts the <port> argument is omitted
                because XRouter knows which port the script is using.


        SEND  - Send a line of text.

                Syntax:  S[end] <text>
                Example: SEND ATDT01674302153

                The SEND command sends one line of text to the modem
                or the remote host, for example modem initialisation
                and dial commands, or login commands.  The <text>
                argument may contain spaces, and the system will
                append a carriage return/line feed.


        SLEEP - Temporary pause.

                Syntax: SL[eep] <millisecs>
                Example: SLEEP 5000

                The SLEEP command causes the script to pause for the
                specified interval.  For example, you would need a
                short delay after issuing a modem reset command
                before any more commands would be accepted by the
                modem.  When the pause is complete, script execution
                continues on the next line.


        WAIT  - Wait for received text.

                Syntax: W[ait] <millisecs> <string> [exiterr]
                Example: WAIT 5000 Password: exiterr

                WAIT causes XRouter to wait for specific responses
                from the modem or remote host.  <millisecs> specifies
                the maximum wait interval.  <string> specifies the
                string of characters (20 chars max, no spaces) to wait
                for.

                When the string is seen in the received data stream,
                the next script command is executed.

                If "exiterr" is present, the script will abort if the
                string is not seen before the interval expires.  If
                not present, the next script command will be executed
                upon timeout.


        Dial up networking may be administered "on the fly" using the
        DUN command , which is detailed in the sysop command reference
        section. The DUN ADD and DUN LOG commands may also be used in
        IPROUTE.SYS and / or BOOTCMDS.SYS to configure the system at
        boot time.


        Example DUN script
        ~~~~~~~~~~~~~~~~~~

        ; Xrouter DUN script for establishing PPP connection with ISP
        ;
        ; Upon connection, the ISP sends some greetings text, then
        ;   "Login:", and waits for login name.
        ;
        ; Upon receiving the login name it sends "Password:" and
        ;   waits for the caller to send the password.
        ;
        ; Upon receiving the password, the ISP sends
        ;   "Entering PPP mode".
        ;
        ;
        ; Drop DTR to reset any modem error condition
        control down
        ;
        ; Wait for 1 sec
        sleep 1000
        ;
        ; Raise DTR to allow normal operation
        control up
        ;
        ; Specify the mode to use after link is established
        mode ppp
        ;
        ; ISP requires PAP authentication: username=gb7pzt,
        ;   password=bsfjflavs
        ppp pap user gb7pzt bsfjflavs
        ;
        ; Get the modem's attention
        send AT
        ;
        ; Wait for up to 5 secs for an "OK" response.  Abort if none
        wait 5000 OK exiterr
        ;
        ; Modem is awake.  Dial the ISP
        send ATDT01905643000
        ;
        ; Wait for up to 1 minute for the "user:" login prompt
        wait 60000 user exiterr
        ;
        ; Prompt obtained. Send username
        send gb7pzt
        ;
        ; Don't bother waiting for "password:" prompt, just send
        ;   it after 1 sec.
        sleep 1000
        send bsfjflavs
        ;
        ; Wait for confirmation of entry to PPP mode
        wait 30000 PPP exiterr
        ;
        ; ISP is now in PPP mode.  XRouter will enter PPP mode when
        ;   script ends
        ;

SEE ALSO
        DIAL(1) -- Dialer
        DUN(1) -- Dial Up Networking commands
        DUN(9) -- Dial Up Networking

SCRIPT(9)                    END OF DOCUMENT
