SERVERS(9)             XROUTER REFERENCE MANUAL             21/10/2023

NAME
        SERVERS -- Servers Available in XRouter.

DESCRIPTION
        In the XRouter context, servers are processes which accept
        connections or data from users (i.e. clients) and provide
        specific services (e.g. file transfer) to those clients.

        They are often associated with a specific TCP or UDP "service
        port" number, for example TCP port 21 for file transfer, UDP
        port 53 for DNS server and so on.

        XRouter contains a number of servers and makes them available
        by default, although they may be disabled by the sysop if
        desired.

        The policy of making services available by default is an
        attempt to provide useful services to the Amateur Radio
        Packet Network (amprnet) with minimal effort on the part of
        the sysop. If services were disabled by default, most sysops
        wouldn't enable them, either because they didn't understand
        them, or because they couldn't be bothered.

        Access to the benign servers is unrestricted, but most are
        protected by password and IP access control lists.

        The following servers are available in XRouter

        Name     Port   Proto   Function
        ---------------------------------------------------
        ECHO        7   TCP     Echoes data back
        DISCARD     9   TCP     Discards data
        FTP        21   TCP     File Transfer
        TELNET     23   TCP     User session
        DNS        53   UDP     Domain Name System
        FINGER     79   TCP     User information
        HTTP       80   TCP     Web server
        TTYLINK    87   TCP     Keyboard to Keyboard chat
        RLOGIN    513   TCP     Remote Login (sysop)
        SOCKS    1080   TCP     SOCKS Proxy
        APRS     1448   TCP     Serves APRS data
        MQTT     1883   TCP     Message Queue Telemetry Transport
        TELPROXY 2323   TCP     Raw TCP to AX25 bridge
        CHAT     3600   TCP     Conferencing
        AGWHOST  8000   TCP     AGW Packet Engine emulator
        RHP      9000   TCP     Remote application support
        HAMLIB      -   TCP     HamLib Emulator
        RIGSRV      -   TCP     Radio control server
        PMS         -     -     Personal Mail Server

        For details of how to move the above ports or disable the
        servers, please see the TCP-PORTS page.


        Brief Overview Of XRouter Servers
        =================================

        ECHO
        ~~~~
        Anything the user sends is echoed back to him.  This is a
        useful tool for test purposes. This server is also available
        from the command prompt, and as NetRomX service 7.


        DISCARD
        ~~~~~~~
        This simply dumps anything sent to it.  It is another useful
        tool for test purposes. This server is also available from the
        command prompt, and as NetRomX service 9.


        FTP
        ~~~
        Allows sysops to upload, download, move and rename files,
        create and remove directories etc. Not available to users.


        TELNET
        ~~~~~~
        Provides regular user access to the XRouter command prompt.
        Also available as NetRomX service 23.


        DNS
        ~~~
        Answers Domain Name System (DNS) queries, to provide a
        hostname to IP-address translation service. 


        FINGER
        ~~~~~~
        Allows users to retrieve information about other users or any
        other topics provided by the sysop. This server is also
        available from the command prompt, and as NetRomX service 79.


        HTTP
        ~~~~
        Serves HTML (web) pages, and provides a browser interface to
        XRouter. Can be made available on both XRouter and host
        system TCP stacks, plus NetRomX service 80.


        TTYLINK
        ~~~~~~~
        For direct keyboard to keyboard chat. Als avaiable on NetRomX
        service 79.


        RLOGIN
        ~~~~~~
        Secure remote login for sysops only, providing full syop-mode
        access.


        SOCKS Proxy
        ~~~~~~~~~~~
        Circuit level proxy allowing applications to access external
        services through a firewall as an alternative to NAT.


        APRS
        ~~~~
        Shares APRS data between clients such as UI-View, RF ports
        and the Internet APRS-IS systems. Can be made avaiable on
        both XRouter and host TCP stack, plus NetRomX service 14. 


        MQTT
        ~~~~
        Machine to machine information broker using a publish /
        subscribe paradigm. Allows sending and receiving of raw KISS,
        AX25, NetRom, XRChat etc, plus status / event information.
        Can be used to develop modern user interfaces.  Available on
        Linux TCP stack only. Also available, with restrictions, via
        NetRomx service 1883.


        TELPROXY
        ~~~~~~~~
        The Telnet Proxy server allows TCP/IP applications to make
        fully transparent raw binary connections (i.e. ones capable of
        handling compressed forwarding) to AX25 or NetRom
        destinations.


        CHAT
        ~~~~
        Allows groups of users to hold conferences, either locally or
        globally via a network of interconnected servers. Also on 
        NetRomX service 8.


        AGWHOST
        ~~~~~~~
        Emulates the AGW TCP host interface, enabling XRouter to
        support applications (e.g. UI-View) that were designed for
        use with the AGW Packet Engine.


        RHP
        ~~~
        Allows XRouter to support a wide range of applications which
        may be located on the same PC or remotely, using a
        socket-like paradigm.


        PMS
        ~~~
        A no-frills mailbox which can handle both private mail and
        bulletins. It is available from AX25 and the XRouter command
        prompt, but currently has no TCP port of its own. Available
        as NetRomX service 2.


        HAMLIB
        ~~~~~~
        Emulates the HamLib rig control interface, for use with
        applications that are designed to use Hamlib.  Available
        only on Linux TCP/IP stack.  Useful only when XRouter is
        controlling rigs.


        RIGSRV
        ~~~~~~
        Another radio control interface (private project).
        Available only on Linux TCP/IP stack.  Useful only when
        XRouter is controlling rigs.

SEE ALSO
        CHAT-SRV(9)   -- Chat Server
        DISCARD(1)    -- Start a Sink Session
        ECHO(1)       -- Start an Echo Session
        FINGER(1)     -- Display User Information
        TCP-PORTS(6)  -- TCP Server Ports

SERVERS(9)                  END OF DOCUMENT
