SERVICES(9)            XROUTER REFERENCE MANUAL             22/10/2023

NAME
        SERVICES -- NetRomX Standard Services.

DESCRIPTION
        G8PZT extended NetRom at the turn of the century to create
        "NetRomX". This uses an alternative L4 connect request, with
        opcode 8, and the mnemonic "CREQX". This type of request
        includes a 16-bit "service number", and can therefore request
        connection to any of 65536 separate types of process on the
        target system.

        This is a major improvement over "standard" NetRom, which only
        allowed a node to host a maximum of 16 L4 services, one per
        SSID. This was not just a barrier to the development of novel
        services... In order to be connectable via L4, every such SSID
        had to be in everyone's nodes tables. And there was no
        agreement on which SSID should represent which service.

        With NetRomX there is no need to clutter the nodes tables with
        SSID's, because every service has a STANDARD number, as shown
        in the table below: 
 
        No.     Service   Description
        ------------------------------------------------------------
        0       CMD       Normal connection to Node's command line
        1       INFO      Standard Information server
        2       PMS       Personal Message System
        3       BBS       (reserved for Bulletin Board System)
        4       DX        (reserved for DX cluster/dx-spot feed)
        5       TPP       (reserved for "Tampa Ping-Pong" chat)
        7       ECHO      Echoes data back to sender
        8       CHAT      XRChat server 
        9       DISCARD   Data sink
        10      RMS       (reserved for winlink RMS}
        11      BPQCHAT   (reserved for BPQ chat server)
        13      DAYTIME   Local date/time (similar to RFC867)
        14      APRS      APRS Server
        15      CUSTINF   (reserved for custom information file server)
        16      WX        Local weather information
        17      TELEM     (reserved for Telemetry server)
        18      SMS       Short Message System server
        19      CHARGEN   Generates a test pattern
        20      NDATA     (reserved for NFTP extension)
        21      NFTP      Netrom File Transfer Protocol
        22      NSSH      (reserved for secure login - if legal?)
        23      TELNET    Normal L4 login (same as 0)
        25      SMTP      (reserved for Simple Mail Transfer Protocol)
        26      MHEARD    MHEARD server (shows MH lists)
        27      DXLIST    DX List server (shjows DX lists)
        79      FINGER    Finger server
        80      HTTP      NetromWeb (HTTP over Netrom) server
        87      NTTY      Netrom TTY - Keyboard to keyboard chat
        1883    MQTT      MQTT server

        If you know that the target system is XRouter (usually they
        have "XR" in the alias), you can be sure that if their PMS is
        enabled, it will be on service 2.

        Standard services facilitate simple commands such as
        "TIME <nodecall>", to discover the local time, time zone and
        daylight saving status at a distant node. Or "PMS <nodecall>"
        to connect directly to someone's PMS.

        It is envisaged that some of the services may be used by
        network crawlers (human and machine) to harvest data without
        needing to know the exact format of the commands on all the
        different types of software.

SEE ALSO
        APRS-SVC(9)  -- APRS Service.
        CHARGEN(9)   -- Character Generator Service.
        CHAT-SVC(9)  -- Chat Service.
        DAYT-SVC(9)  -- DAYTIME Service.
        DX-SVC(9)    -- DX Service
        DISC-SVC(9)  -- Discard Service
        ECHO-SVC(9)  -- Echo Service.
        HTTP-SVC(9)  -- HTTP Service.
        INFO-SVC(9)  -- Information Service.
        MH-SVC(9)    -- MHeard Service
        MQTT-SVC(9)  -- MQTT Service
        NFTP-SVC(9)  -- Netrom File Transfer Service.
        NTTY-SVC(9)  -- NetromTTY Service.
        PMS-SVC(9)   -- Personal Message Service.
        SMS-SVC(9)   -- Short Message Service
        TCP-PORTS(6) -- TCP Server Ports
        WX-SVC(9)    -- Weather Service.

SERVICES(9)             END OF DOCUMENT
