;*************************** Max Width *******************************
SESSLIMIT(7)            XROUTER REFERENCE MANUAL             26/9/2023

NAME
        SESSLIMIT -- Maximum Simultaneous Connections on Port.

SYNOPSIS
        SESSLIMIT=n (where n is 0 to 255)

DESCRIPTION
        SESSLIMIT is an optional PORT directive used in XROUTER.CFG.

        It specifies the maximum simultaneous connections each user
        is allowed on the port. The default is 255, i.e. unlimited.

        This would typically be used to "choke" users who hog all
        the bandwidth on a port with too many connections.

        There is a global limit on the number of AX25 links, namely
        MAXLINKS (default=30), so on a multi-port node it is worth
        setting SESSLIMIT substantially lower than MAXLINKS.

        The user must however use a different SSID for each
        connection on any given PORT, which limits his maximum
        number of connections to 16.
 
EXAMPLE
        SESSLIMIT=5 

SEE ALSO
        MAXLINKS(7)    -- Global Maximum AX25 Connections.
        PORTS(6)       -- Ports in XRouter.
        USERS(7)       -- Maximum Users on Port.
        XROUTER.CFG(8) -- Main Configuration File.

SESSLIMIT(7)                 END OF DOCUMENT
