SLIP(9)                 XROUTER REFERENCE MANUAL            19/10/2023

NAME
        SLIP -- Serial Line IP.

DESCRIPTION
        SLIP is a very simple protocol which encapsulates Internet
        Protocol (IP) datagrams for transmission over serial (e.g.
        RS232) lines. It is defined in RFC 1055.

        The SLIP protocol specifies the following special characters:

                Name  Hex   Dec  Purpose
                ---------------------------
                FEND  0xC0  192  Frame End
                FESC  0xDB  219  Frame Escape

        The FEND characters mark the start and end of the frame
        containing the encapsulated datagram as follows:

                .------.-------------.------.
                | FEND | IP Datagram | FEND |
                '------'-------------'------'

        In order to ensure that the FEND character only occurs at the
        start and end of the frame, FENDs which occur within the
        unencapsulated datagram are "escaped" to the two byte sequence
        FESC 220. Likewise FESC is escaped to the sequence FESC 221.

        It is permissible for two datagrams to share a FEND:

                .------.-------------.------.-------------.------.
                | FEND | IP Datagram | FEND | IP Datagram | FEND |
                '------'-------------'------'-------------'------'


        Serial Line Parameters
        ~~~~~~~~~~~~~~~~~~~~~~

        Serial lines used for SLIP must run at 8 data bits. Flow
        control must be hardware or none, as XON/XOFF flow control
        would interfere with the protocol.

        If flow control is used, the cable must contain at least 5
        cores, namely TXD, RXD, RTS, CTS and GND.  If flow control is
        not used, only TXD, RXD and GND are required.

        In all cases, a NULL MODEM is required. In the case of "real"
        RS232 this could be an actual null modem device, or a cable
        that is wired such that the TXDs at each end go to the RXDs
        at the other end, and the RTSs at each end go to the CTSs at
        the other.  "Virtual" COM port pairs such as Com0Com
        (Windows) or tty/pty pairs (Linux) include this functionality
        as standard.


        Configuring a SLIP Link
        ~~~~~~~~~~~~~~~~~~~~~~~

        SLIP can be used to link XRouter with other IP systems (e.g.
        NOS) via real or virtual COM ports. A typical configuration
        in XROUTER.CFG would be as follows:

                INTERFACE=13
                        TYPE=ASYNC     <-- Serial RS232
                        COM=13         <-- COM number / device	
                        PROTOCOL=SLIP  <-- Use SLIP
                        SPEED=38400    <-- Baud rate
                        FLOW=0         <-- No flow control
                        MTU=1500       <-- Allows largest IP
                ENDINTERFACE

                PORT=3
                        ID=SLIP Link to BBS
                        INTERFACENUM=13
                ENDPORT

        Unless overridden with a port IPADDRESS statement, the SLIP
        link will use XRouter's "core" IP address, i.e. the one
        specified by the global IPADDRESS. This is usually a 44-net
        address.

        Remember to set up an IP ROUTE entry for the neighbour system
        via this PORT number, e.g. if the neighbour's IP address is
        44.131.91.2, the following entry routes traffic to it via
        port 3 using datagram mode:

                IP ROUTE ADD 44.131.91.2  * 3  d

        Note that "virtual circuit" (v) and "netrom" (n) routing
        modes can not be used here.

        A SLIP link thus created does not involve the Windows or
        Linux IP stack in any way, therefore there is no restriction
        on the protocols that can be carried within the IP datagrams.

        For example you may create an AX25 link using AXIP, or tunnel
        traffic over the link using IPEncap. 

        SLIP was largely replaced by PPP long ago, but the beauty of
        it is its simplicity.  It is so easy to configure, and only
        requires a pair of COM ports and a 3 core cable.


        Temporary SLIP
        ~~~~~~~~~~~~~~

        A dial-in MODEM connection may be switched into SLIP mode for
        the remainder of the call using the "XLINK SLIP" command,
        thus emulating an old-fashioned dial-up ISP.

        This may possibly be of use for controlling remote sites that
        have telephone lines but no Internet connection.  Or even as
        a backup in case an Internet connection breaks down (cheap
        routers and switches fail!). See the manual entry for PSTN
        for more details.

SEE ALSO
        IP(1)          -- IP Routing / Configuration Commands.
        IPROUTE.SYS(8) -- IP Configuration File.
        KISS(9)        -- KISS Protocol.
        XLINK(1)       -- Establish a Temporary SLIP / PPP Interlink
        XROUTER.CFG(8) -- Main Configuration File.

SLIP(9)                   END OF DOCUMENT
