;*************************** Max Width *******************************
SLOTTIME(7)            XROUTER REFERENCE MANUAL              26/9/2023

NAME
        SLOTTIME -- CSMA Interval Time.

SYNOPSIS
        SLOTTIME=<millisecs>

DESCRIPTION
        SLOTTIME is an optional PORT directive used in XROUTER.CFG.

        It specifies the CSMA (Carrier Sense Multiple Access)
        interval time, used with PERSIST to make channel access
        decisions. The value is in milliseconds (default=100).

        If the channel is clear, the TNC (or SCC/YAM card) generates
        a random number which is then compared with PERSIST. If the
        random number is less than PERSIST, the TNC will wait for the
        SLOTTIME interval, then repeat the action, otherwise it will
        transmit immediately.

        This improves throughput by ensuring that everyone doesn't
        transmit as soon as the channel is clear, which would cause
        collisions and retries.

        The value can be changed "on the fly" using the SLOTTIME
        command.

EXAMPLE
        SLOTTIME=100   ; 100 millisecs per slot 

SEE ALSO
        SLOTTIME(1)    -- Display / Set CSMA Interval.
        PERSIST(7)     -- AX25 Probablity to Transmit.
        PORTS(6)       -- Ports in XRouter.
        XROUTER.CFG(8) -- Main Configuration File.

SLOTTIME(7)                END OF DOCUMENT
