SMS(1)               XROUTER REFERENCE MANUAL                10/9/2023

COMMAND
        SMS -- Short Messaging System for XR sysops.

SYNOPSIS
        SMS [nodecall [text]]

AVAILABILITY
        Sysop-only.

DESCRIPTION
        The SMS command can either invoke an SMS client, or directly
        send a short message to the sysop of another XRouter. This is
        a messaging service for XRouter sysops, and has nothing to do
        with telephone SMS.

        Sysops have a need to communicate with each other. Some of
        them leave messages for each other on the sysop chat, but
        that tends to scroll off the screen and get lost. It is also
        very public, and unecessarily broadcasts the message to every
        chat server. The PMS can be used, but it isn't very "instant",
        and has no sense of "conversation"; only a random list of
        incoming messages.

        To try and solve this problem, the SMS system was created.

        Unlike the BBS system, SMS messages are delivered directly
        from the source node to the recipient node, without
        intermediate store and forward. Thus it curently only works
        with nodes that are in your list. However, as most XRouter
        nodes are known to each other, that's not much of a problem.
        In future there will be no such restriction.

        There is a "read receipt" mechanism, so the sender knows
        whether or not their message has been received and read.

        The recipent is alerted to the presence of a short message
        by a flashing "S" on the top status bar. The SMS client is
        used to display the messages, send relies etc.

        The SMS Client
        ~~~~~~~~~~~~~~
        Upon entering the client, any new message(s) are displayed.
        If there is more than one new message in a conversation, the
        first unread one is displayed:

            sms
            G8PZT-1:MOBILE} Starting SMS Client..

            SMS Conversations:

               Nodecall   New  Date/Time    Text
               G8PZT-14     0  09/06 02:56  another test back from me
               G8PZT        0  18/05 03:27  test at 03:25 tuesday

            R)ead   S)end   A)rchive   D)elete   E)xit SMS

        Note that unlike a PMS or BBS, this is CONVERSATION not
        MESSAGE oriented. 

        Each {nodecall} in the above list indicates a conversation
        with the sysop of that node. A conversation consists of one
        or more messages between you and the other party in strict
        chronological sequence. Both sides of the conversation are
        included.

        The argument to each command, with the exception of "E)xit",
        is a {nodecall}, i.e. a conversation. So "A)rchive G8PZT"
        archives the conversation to a file, removing it from the
        list.

            R)ead     Reads a conversation
            S)end     Sends a message to a conversation
            A)rchive  Removes conversation & archives it to disk.
            D)elete   Permanently deletes a conversation.
            E)xit     Exits the client and returns to the node.

        "R G8PZT" reads the conversation between you and G8PZT,
        starting at the first unread message. If there are no unread
        messages it displays the last message.

        In this example there are both previous and subsequent
        messages, which can be displayed using the Next and P)revious
        commands:

            r g8pzt

            Sent: 18/05/21 03:27:20
              To: G8PZT

            test at 03:25 tuesday

            S)end,  N)ext,  P)revious,  C)onversations,  E)xit SMS

        The "S)end" option is a little ambiguous in this menu, and
        shows how unfinished the user interface is!! It really means
        "create a new message", not "send the above message".

        The C)onversations option returns you to the list of
        conversations.

OPTIONS
        Typing "SMS" by itself invokes the SMS client, from where
        you view the conversations, read, send, and delete messages.

        The "SMS <nodecall>" form initiates the sending of a message,
        and prompts for the message body.

        The "SMS <nodecall> <text>" form sends a message instantly,
        and returns to the command line.

EXAMPLES
        SMS
        SMS G8PZT
        SMS G8PZT I'll be on sysop chat at 3pm UTC

SEE ALSO
        CHAT(1)    -- Connect to chat server
        PMS(1)     -- Personal Message System
        SMS-SVC(9) -- SMS Service

SMS(1)                  END OF DOCUMENT
